/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.feign;

import feign.Response;
import lombok.Generated;
import org.bonitasoft.web.client.BonitaClient;
import org.bonitasoft.web.client.api.SessionApi;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.model.Session;
import org.bonitasoft.web.client.services.ApplicationService;
import org.bonitasoft.web.client.services.BdmService;
import org.bonitasoft.web.client.services.LoginService;
import org.bonitasoft.web.client.services.ProcessService;
import org.bonitasoft.web.client.services.SystemService;
import org.bonitasoft.web.client.services.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BonitaFeignClient
implements BonitaClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BonitaFeignClient.class);
    private final String url;
    private final ApiProvider apiProvider;
    private final LoginService loginService;
    private final ApplicationService applicationService;
    private final BdmService bdmService;
    private final UserService userService;
    private final ProcessService processService;
    private final SystemService systemService;

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Session login(String username, String password) {
        return this.login(username, password, "1");
    }

    @Override
    public Session login(String username, String password, String tenant) {
        log.info("Try login user {} on tenant {}", (Object)username, (Object)tenant);
        Session session = this.loginService.login(username, password, tenant);
        log.debug("User logged in: {}", (Object)session);
        return session;
    }

    @Override
    public void logout() {
        log.info("Logout user");
        this.loginService.logout();
    }

    @Override
    public void logoutSilent() {
        try {
            this.logout();
        }
        catch (Exception e) {
            log.debug("Ignoring error as we are performing a silent logout", (Throwable)e);
        }
    }

    @Override
    public boolean isPlatformUpAndRunning() {
        boolean bl;
        block8: {
            Response response = this.apiProvider.get(SessionApi.class).getSession();
            try {
                boolean bl2 = bl = response.status() == 401 || response.status() == 200;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    @Override
    public String getVersion() {
        log.info("Get Bonita version");
        Session session = this.loginService.getSession();
        String version = session.getVersion();
        log.debug("Bonita version: {}", (Object)version);
        return version;
    }

    @Override
    public <T extends ApiClient.Api> T get(Class<T> apiClass) {
        log.debug("Access http api: {}", (Object)apiClass.getName());
        return this.apiProvider.get(apiClass);
    }

    @Override
    public ApplicationService applications() {
        return this.applicationService;
    }

    @Override
    public BdmService bdm() {
        return this.bdmService;
    }

    @Override
    public UserService users() {
        return this.userService;
    }

    @Override
    public ProcessService processes() {
        return this.processService;
    }

    @Override
    public SystemService system() {
        return this.systemService;
    }

    @Generated
    public BonitaFeignClient(String url, ApiProvider apiProvider, LoginService loginService, ApplicationService applicationService, BdmService bdmService, UserService userService, ProcessService processService, SystemService systemService) {
        this.url = url;
        this.apiProvider = apiProvider;
        this.loginService = loginService;
        this.applicationService = applicationService;
        this.bdmService = bdmService;
        this.userService = userService;
        this.processService = processService;
        this.systemService = systemService;
    }
}

