/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.invoker.auth;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class BonitaCookieAuth
implements RequestInterceptor {
    public static final String CSRF_TOKEN_HEADER = "X-Bonita-API-Token";
    private String cookie;
    private String csrfHeader;

    public String getCookie() {
        return this.cookie;
    }

    public String getCsrfHeader() {
        return this.csrfHeader;
    }

    public void clearSessionCookie() {
        this.cookie = null;
        this.csrfHeader = null;
    }

    public void initFrom(Map<String, Collection<String>> loginHeaders) {
        Map<String, String> cookies = ((Collection)loginHeaders.getOrDefault("set-cookie", Collections.emptyList())).stream().map(cookieHeader -> cookieHeader.split("=", 2)).collect(Collectors.toMap(cookieHeaderPair -> cookieHeaderPair[0], cookieHeaderPair -> cookieHeaderPair[1].split(";")[0], (oldValue, newValue) -> newValue));
        this.csrfHeader = cookies.remove(CSRF_TOKEN_HEADER);
        this.cookie = cookies.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(";"));
    }

    public void apply(RequestTemplate requestTemplate) {
        if (this.cookie != null) {
            requestTemplate.header("Cookie", new String[]{this.cookie});
        }
        if (this.csrfHeader != null) {
            requestTemplate.header(CSRF_TOKEN_HEADER, new String[]{this.csrfHeader});
        }
    }
}

