/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.feign.decoder;

import feign.Response;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import org.bonitasoft.web.client.exception.ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingDecoder
implements Decoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelegatingDecoder.class);
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final Map<String, Decoder> delegates = new HashMap<String, Decoder>();
    private final Decoder defaultDecoder = new Decoder.Default();

    public Object decode(Response response, Type type) throws IOException {
        Collection contentTypeHeader = (Collection)response.headers().get(CONTENT_TYPE_HEADER);
        if (contentTypeHeader == null) {
            return this.defaultDecoder.decode(response, type);
        }
        String contentType = (String)contentTypeHeader.stream().findFirst().orElseThrow(() -> new ClientException("No Content-Type header in response headers."));
        log.debug("Decoding body with content-type: {}", (Object)contentType);
        return this.delegates.entrySet().stream().filter(this.contentTypeRegistered(contentType)).findFirst().map(Map.Entry::getValue).map(decoder -> this.decodeNoException((Decoder)decoder, response, type)).orElseGet(() -> this.decodeNoException(this.defaultDecoder, response, type));
    }

    private Predicate<Map.Entry<String, Decoder>> contentTypeRegistered(String contentType) {
        return decoderEntry -> {
            String registeredType = ((String)decoderEntry.getKey()).toLowerCase();
            String responseContentType = contentType.toLowerCase();
            return responseContentType.startsWith(registeredType);
        };
    }

    private Object decodeNoException(Decoder decoder, Response response, Type type) {
        try {
            Object object = decoder.decode(response, type);
            return object;
        }
        catch (IOException e) {
            throw new ClientException("Failed to decode response", e);
        }
        finally {
            response.close();
        }
    }

    public DelegatingDecoder register(String contentType, Decoder decoder) {
        this.delegates.put(contentType, decoder);
        return this;
    }
}

