/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.feign.interceptor;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class BonitaCharsetBugInterceptor
implements Interceptor,
RequestInterceptor {
    static final String CONTENT_TYPE_HEADER = "Content-Type";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String contentType = request.header(CONTENT_TYPE_HEADER);
        if (contentType != null) {
            Request.Builder builder = request.newBuilder();
            builder.removeHeader(CONTENT_TYPE_HEADER);
            builder.header(CONTENT_TYPE_HEADER, this.cleanContentType(contentType));
            request = builder.build();
        }
        return chain.proceed(request);
    }

    @NotNull
    String cleanContentType(String contentType) {
        return contentType.replace("; charset=utf-8", "").replace(";charset=utf-8", "").replace("; charset=UTF-8", "").replace(";charset=UTF-8", "").replace("; Charset=utf-8", "").replace(";Charset=utf-8", "").replace("; Charset=UTF-8", "").replace(";Charset=UTF-8", "");
    }

    public void apply(RequestTemplate requestTemplate) {
        Optional contentTypeHeader = ((Collection)requestTemplate.headers().getOrDefault(CONTENT_TYPE_HEADER, Collections.emptyList())).stream().findFirst();
        contentTypeHeader.ifPresent(contentType -> requestTemplate.header(CONTENT_TYPE_HEADER, Collections.singleton(this.cleanContentType((String)contentType))));
    }
}

