/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.invoker;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.Types;
import feign.jackson.JacksonDecoder;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.bonitasoft.web.client.model.ApiResponse;

public class ApiResponseDecoder
extends JacksonDecoder {
    public ApiResponseDecoder(ObjectMapper mapper) {
        super(mapper);
    }

    public Object decode(Response response, Type type) throws IOException {
        if (type instanceof ParameterizedType && Types.getRawType((Type)type).isAssignableFrom(ApiResponse.class)) {
            Type responseBodyType = ((ParameterizedType)type).getActualTypeArguments()[0];
            Object body = super.decode(response, responseBodyType);
            Map<String, Collection<String>> responseHeaders = Collections.unmodifiableMap(response.headers());
            return new ApiResponse<Object>(response.status(), responseHeaders, body);
        }
        return super.decode(response, type);
    }
}

