/** 
 * Copyright (C) 2024-2023 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2.0 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.bonitasoft.web.client.model;

import java.io.Serializable;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ProcessInstanceCommentCreateRequest
 */
@JsonPropertyOrder({
        ProcessInstanceCommentCreateRequest.JSON_PROPERTY_PROCESS_INSTANCE_ID,
        ProcessInstanceCommentCreateRequest.JSON_PROPERTY_CONTENT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.12.0")
public class ProcessInstanceCommentCreateRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
    @jakarta.annotation.Nullable
    private String processInstanceId;

    public static final String JSON_PROPERTY_CONTENT = "content";
    @jakarta.annotation.Nullable
    private String content;

    public ProcessInstanceCommentCreateRequest() {
    }

    public ProcessInstanceCommentCreateRequest processInstanceId(
            @jakarta.annotation.Nullable String processInstanceId) {

        this.processInstanceId = processInstanceId;
        return this;
    }

    /**
     * the process instance (case) the comment is associated to
     * 
     * @return processInstanceId
     */
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getProcessInstanceId() {
        return processInstanceId;
    }

    @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstanceId(@jakarta.annotation.Nullable String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ProcessInstanceCommentCreateRequest content(@jakarta.annotation.Nullable String content) {

        this.content = content;
        return this;
    }

    /**
     * the comment content
     * 
     * @return content
     */
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_CONTENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getContent() {
        return content;
    }

    @JsonProperty(JSON_PROPERTY_CONTENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContent(@jakarta.annotation.Nullable String content) {
        this.content = content;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceCommentCreateRequest processInstanceCommentCreateRequest = (ProcessInstanceCommentCreateRequest) o;
        return Objects.equals(this.processInstanceId, processInstanceCommentCreateRequest.processInstanceId) &&
                Objects.equals(this.content, processInstanceCommentCreateRequest.content);
    }

    @Override
    public int hashCode() {
        return Objects.hash(processInstanceId, content);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceCommentCreateRequest {\n");
        sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
        sb.append("    content: ").append(toIndentedString(content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
