/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client;

import org.bonitasoft.web.client.BonitaClientBuilder;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.feign.BonitaFeignClientBuilderImpl;
import org.bonitasoft.web.client.model.Session;
import org.bonitasoft.web.client.services.ApplicationService;
import org.bonitasoft.web.client.services.BdmService;
import org.bonitasoft.web.client.services.ProcessService;
import org.bonitasoft.web.client.services.SystemService;
import org.bonitasoft.web.client.services.UserService;

public interface BonitaClient
extends ApiProvider {
    public static final String USER_PROFILE_NAME = "User";
    public static final String ADMIN_PROFILE_NAME = "Administrator";

    public static <T extends BonitaClientBuilder<T>> BonitaClientBuilder<T> builder(String url) {
        return new BonitaFeignClientBuilderImpl(url);
    }

    public Session login(String var1, String var2);

    public void setBearerToken(String var1);

    public void logout();

    public void logoutSilent();

    public boolean isPlatformUpAndRunning();

    public String getUrl();

    public String getVersion();

    public ApplicationService applications();

    public BdmService bdm();

    public UserService users();

    public ProcessService processes();

    public SystemService system();
}

