/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bonitasoft.web.client.model.MessageMessageContentValue;

@JsonPropertyOrder(value={"messageName", "targetProcess", "targetFlowNode", "messageContent", "correlations"})
public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_MESSAGE_NAME = "messageName";
    @Nullable
    private String messageName;
    public static final String JSON_PROPERTY_TARGET_PROCESS = "targetProcess";
    @Nullable
    private String targetProcess;
    public static final String JSON_PROPERTY_TARGET_FLOW_NODE = "targetFlowNode";
    @Nullable
    private String targetFlowNode;
    public static final String JSON_PROPERTY_MESSAGE_CONTENT = "messageContent";
    @Nullable
    private Map<String, MessageMessageContentValue> messageContent = new HashMap<String, MessageMessageContentValue>();
    public static final String JSON_PROPERTY_CORRELATIONS = "correlations";
    @Nullable
    private Map<String, MessageMessageContentValue> correlations = new HashMap<String, MessageMessageContentValue>();

    public Message messageName(@Nullable String messageName) {
        this.messageName = messageName;
        return this;
    }

    @Nullable
    @JsonProperty(value="messageName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessageName() {
        return this.messageName;
    }

    @JsonProperty(value="messageName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessageName(@Nullable String messageName) {
        this.messageName = messageName;
    }

    public Message targetProcess(@Nullable String targetProcess) {
        this.targetProcess = targetProcess;
        return this;
    }

    @Nullable
    @JsonProperty(value="targetProcess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetProcess() {
        return this.targetProcess;
    }

    @JsonProperty(value="targetProcess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetProcess(@Nullable String targetProcess) {
        this.targetProcess = targetProcess;
    }

    public Message targetFlowNode(@Nullable String targetFlowNode) {
        this.targetFlowNode = targetFlowNode;
        return this;
    }

    @Nullable
    @JsonProperty(value="targetFlowNode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetFlowNode() {
        return this.targetFlowNode;
    }

    @JsonProperty(value="targetFlowNode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetFlowNode(@Nullable String targetFlowNode) {
        this.targetFlowNode = targetFlowNode;
    }

    public Message messageContent(@Nullable Map<String, MessageMessageContentValue> messageContent) {
        this.messageContent = messageContent;
        return this;
    }

    public Message putMessageContentItem(String key, MessageMessageContentValue messageContentItem) {
        if (this.messageContent == null) {
            this.messageContent = new HashMap<String, MessageMessageContentValue>();
        }
        this.messageContent.put(key, messageContentItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="messageContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, MessageMessageContentValue> getMessageContent() {
        return this.messageContent;
    }

    @JsonProperty(value="messageContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessageContent(@Nullable Map<String, MessageMessageContentValue> messageContent) {
        this.messageContent = messageContent;
    }

    public Message correlations(@Nullable Map<String, MessageMessageContentValue> correlations) {
        this.correlations = correlations;
        return this;
    }

    public Message putCorrelationsItem(String key, MessageMessageContentValue correlationsItem) {
        if (this.correlations == null) {
            this.correlations = new HashMap<String, MessageMessageContentValue>();
        }
        this.correlations.put(key, correlationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="correlations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, MessageMessageContentValue> getCorrelations() {
        return this.correlations;
    }

    @JsonProperty(value="correlations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCorrelations(@Nullable Map<String, MessageMessageContentValue> correlations) {
        this.correlations = correlations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.messageName, message.messageName) && Objects.equals(this.targetProcess, message.targetProcess) && Objects.equals(this.targetFlowNode, message.targetFlowNode) && Objects.equals(this.messageContent, message.messageContent) && Objects.equals(this.correlations, message.correlations);
    }

    public int hashCode() {
        return Objects.hash(this.messageName, this.targetProcess, this.targetFlowNode, this.messageContent, this.correlations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Message {\n");
        sb.append("    messageName: ").append(this.toIndentedString(this.messageName)).append("\n");
        sb.append("    targetProcess: ").append(this.toIndentedString(this.targetProcess)).append("\n");
        sb.append("    targetFlowNode: ").append(this.toIndentedString(this.targetFlowNode)).append("\n");
        sb.append("    messageContent: ").append(this.toIndentedString(this.messageContent)).append("\n");
        sb.append("    correlations: ").append(this.toIndentedString(this.correlations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

