/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bonitasoft.web.client.api.BdmAccessControlApi;
import org.bonitasoft.web.client.api.BdmApi;
import org.bonitasoft.web.client.api.BusinessDataOperationsApi;
import org.bonitasoft.web.client.api.BusinessDataQueryApi;
import org.bonitasoft.web.client.api.MaintenanceApi;
import org.bonitasoft.web.client.api.UploadApi;
import org.bonitasoft.web.client.exception.ClientException;
import org.bonitasoft.web.client.exception.LicenseException;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.model.BDMAccessControl;
import org.bonitasoft.web.client.model.BDMInstallRequest;
import org.bonitasoft.web.client.model.Bdm;
import org.bonitasoft.web.client.model.BusinessData;
import org.bonitasoft.web.client.model.MaintenanceDetails;
import org.bonitasoft.web.client.model.TenantResourceState;
import org.bonitasoft.web.client.services.BdmService;
import org.bonitasoft.web.client.services.impl.base.AbstractService;
import org.bonitasoft.web.client.services.impl.base.ClientContext;
import org.bonitasoft.web.client.services.impl.bdm.BdmResponseConverter;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBdmService
extends AbstractService
implements BdmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultBdmService.class);
    private final BdmResponseConverter bdmResponseConverter;

    public DefaultBdmService(ClientContext clientContext, ApiProvider apiProvider, BdmResponseConverter bdmResponseConverter) {
        super(apiProvider, bdmResponseConverter.getObjectMapper(), clientContext);
        this.bdmResponseConverter = bdmResponseConverter;
    }

    @Override
    public void importBDM(File bdm) {
        log.info("Importing Business Data Model file: {}", (Object)bdm.getName());
        log.debug("Enabling Maintenance mode ...");
        MaintenanceApi maintenanceApi = this.apiProvider.get(MaintenanceApi.class);
        maintenanceApi.updateMaintenanceDetails(new MaintenanceDetails().maintenanceState(MaintenanceDetails.MaintenanceStateEnum.ENABLED));
        log.debug("Maintenance mode enabled");
        this.deleteBdmAccessControlIfNeeded();
        UploadApi uploadApi = this.apiProvider.get(UploadApi.class);
        String uploadedFileName = uploadApi.uploadFile(bdm);
        log.debug("BDM file uploaded");
        BdmApi bdmApi = this.apiProvider.get(BdmApi.class);
        bdmApi.installBDM(new BDMInstallRequest().fileUpload(uploadedFileName));
        log.debug("BDM file installed");
        log.debug("Disabling Maintenance mode ...");
        maintenanceApi.updateMaintenanceDetails(new MaintenanceDetails().maintenanceState(MaintenanceDetails.MaintenanceStateEnum.DISABLED));
        log.debug("Maintenance mode disabled");
        log.info("Business Data Model deployed successfully.");
    }

    @Override
    public void importBdmAccessControl(File accessControl) {
        log.info("Importing BDM AccessControl file: {}", (Object)accessControl.getName());
        this.deleteBdmAccessControlIfNeeded();
        BdmAccessControlApi bdmAccessControlApi = this.apiProvider.get(BdmAccessControlApi.class);
        String uploadedFileName = bdmAccessControlApi.uploadBDMAccessControl(accessControl);
        log.debug("BDM Access Control file uploaded");
        bdmAccessControlApi.importBDMAccessControl(uploadedFileName);
        log.debug("BDM Access Control file installed");
        log.info("BDM AccessControl file imported successfully");
    }

    void deleteBdmAccessControlIfNeeded() {
        if (!this.isCommunity() && TenantResourceState.INSTALLED.equals((Object)this.getBdmAccessControlStatus().getState())) {
            log.debug("Deleting previous BdmAccessControl ...");
            BdmAccessControlApi accessControlApi = this.apiProvider.get(BdmAccessControlApi.class);
            accessControlApi.deleteBDMAccessControl();
            log.debug("Previous BdmAccessControl deleted");
        }
    }

    @Override
    public Bdm getBdmStatus() {
        log.debug("Get BDM status");
        BdmApi bdmApi = this.apiProvider.get(BdmApi.class);
        Bdm bdm = bdmApi.getBdm();
        log.debug("BDM status: {}", (Object)bdm);
        return bdm;
    }

    @Override
    public BDMAccessControl getBdmAccessControlStatus() {
        log.debug("Get BDM Access Control status");
        if (this.isCommunity()) {
            String message = "BDM AccessControl management skipped: your current Bonita license is 'Community' and this feature is only supported in 'Subscription' editions.";
            throw new LicenseException(message);
        }
        BdmAccessControlApi accessControlApi = this.apiProvider.get(BdmAccessControlApi.class);
        BDMAccessControl bdmAccessControlStatus = accessControlApi.getBDMAccessControlStatus();
        log.debug("BDM Access Control status: {}", (Object)bdmAccessControlStatus);
        return bdmAccessControlStatus;
    }

    @Override
    public <T> T querySingle(String businessDataType, String namedQuery, Class<T> queryResultType) {
        List<T> results = this.query(businessDataType, namedQuery, queryResultType);
        return this.getSingleResult(results);
    }

    @Override
    public <T> List<T> query(String businessDataType, String namedQuery, Class<T> queryResultType) {
        log.info("Query BDM for about {} objects", (Object)businessDataType);
        BusinessDataQueryApi.SearchBusinessDataQueryParams queryParams = new BusinessDataQueryApi.SearchBusinessDataQueryParams();
        queryParams.q(namedQuery).p(0).c(Integer.MAX_VALUE);
        return this.query(businessDataType, queryParams, queryResultType);
    }

    @Override
    public <T> T querySingle(String businessDataType, BusinessDataQueryApi.SearchBusinessDataQueryParams queryParams, Class<T> queryResultType) {
        List<T> results = this.query(businessDataType, queryParams, queryResultType);
        return this.getSingleResult(results);
    }

    @Nullable
    private <T> T getSingleResult(List<T> results) {
        if (!results.isEmpty()) {
            if (results.size() != 1) {
                throw new ClientException("Query returned more than one single result:" + String.valueOf(results));
            }
            return results.get(0);
        }
        log.debug("No result found for this query, returning null instead");
        return null;
    }

    @Override
    public <T> List<T> query(String businessDataType, BusinessDataQueryApi.SearchBusinessDataQueryParams queryParams, Class<T> queryResultType) {
        log.info("Query BDM for about {} objects with params {}", (Object)businessDataType, (Object)queryParams);
        BusinessDataQueryApi queryApi = this.apiProvider.get(BusinessDataQueryApi.class);
        List<Object> objects = queryApi.searchBusinessData(businessDataType, queryParams);
        if (BusinessData.class.equals(queryResultType)) {
            return this.bdmResponseConverter.convertToList(objects, BusinessData.class);
        }
        return objects.stream().map(o -> this.bdmResponseConverter.convert(o, queryResultType)).collect(Collectors.toList());
    }

    @Override
    public long createBusinessData(String businessDataType, Map<String, Serializable> fields) {
        log.info("Creating new Business Data of type {}", (Object)businessDataType);
        BusinessDataOperationsApi api = this.apiProvider.get(BusinessDataOperationsApi.class);
        return api.insertBusinessData(businessDataType, fields).getNewBusinessDataId().longValue();
    }

    @Override
    public void updateBusinessData(String businessDataType, long identifier, Map<String, Serializable> fields) {
        log.info("Updating Business Data of type {} with id {}", (Object)businessDataType, (Object)identifier);
        BusinessDataOperationsApi api = this.apiProvider.get(BusinessDataOperationsApi.class);
        api.updateBusinessData(businessDataType, BigDecimal.valueOf(identifier), fields);
    }

    @Override
    public void deleteBusinessData(String businessDataType, long identifier) {
        log.info("Deleting Business Data of type {} with id {}", (Object)businessDataType, (Object)identifier);
        BusinessDataOperationsApi api = this.apiProvider.get(BusinessDataOperationsApi.class);
        api.deleteBusinessData(businessDataType, BigDecimal.valueOf(identifier));
    }

    @Override
    public List<Long> importBusinessDataFile(String businessDataType, File csvFile) {
        log.info("Import Business Data file for type {}", (Object)businessDataType);
        BusinessDataOperationsApi api = this.apiProvider.get(BusinessDataOperationsApi.class);
        return api.importBusinessData(businessDataType, csvFile).getCreatedIds().stream().map(BigDecimal::longValue).collect(Collectors.toList());
    }
}

