/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import lombok.Generated;
import org.bonitasoft.web.client.api.MaintenanceApi;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.model.MaintenanceDetails;
import org.bonitasoft.web.client.services.SystemService;
import org.bonitasoft.web.client.services.impl.base.AbstractService;
import org.bonitasoft.web.client.services.impl.base.ClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSystemService
extends AbstractService
implements SystemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemService.class);

    public DefaultSystemService(ClientContext clientContext, ApiProvider apiProvider, ObjectMapper objectMapper) {
        super(apiProvider, objectMapper, clientContext);
    }

    @Override
    public boolean isMaintenanceModeEnabled() {
        log.info("Check if Maintenance mode is enabled");
        MaintenanceApi maintenanceApi = this.apiProvider.get(MaintenanceApi.class);
        MaintenanceDetails maintenanceDetails = maintenanceApi.getMaintenanceDetails();
        MaintenanceDetails.MaintenanceStateEnum maintenanceState = Optional.ofNullable(maintenanceDetails.getMaintenanceState()).orElse(MaintenanceDetails.MaintenanceStateEnum.DISABLED);
        log.debug("Maintenance State: {}", (Object)maintenanceState);
        return MaintenanceDetails.MaintenanceStateEnum.ENABLED == maintenanceState;
    }
}

