/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.feign;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.Feign;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.bonitasoft.web.client.BonitaClient;
import org.bonitasoft.web.client.exception.ClientException;
import org.bonitasoft.web.client.feign.BonitaFeignClient;
import org.bonitasoft.web.client.feign.BonitaFeignClientBuilder;
import org.bonitasoft.web.client.feign.CachingApiProvider;
import org.bonitasoft.web.client.feign.decoder.BonitaErrorDecoder;
import org.bonitasoft.web.client.feign.decoder.DelegatingDecoder;
import org.bonitasoft.web.client.feign.interceptor.BonitaCharsetBugInterceptor;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.invoker.ApiResponseDecoder;
import org.bonitasoft.web.client.invoker.auth.BonitaCookieAuth;
import org.bonitasoft.web.client.invoker.auth.BonitaLoginService;
import org.bonitasoft.web.client.invoker.auth.HttpBearerAuth;
import org.bonitasoft.web.client.log.LogContentLevel;
import org.bonitasoft.web.client.services.impl.DefaultApplicationService;
import org.bonitasoft.web.client.services.impl.DefaultBdmService;
import org.bonitasoft.web.client.services.impl.DefaultProcessService;
import org.bonitasoft.web.client.services.impl.DefaultSystemService;
import org.bonitasoft.web.client.services.impl.DefaultUserService;
import org.bonitasoft.web.client.services.impl.base.CachingClientContext;
import org.bonitasoft.web.client.services.impl.bdm.BdmResponseConverter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BonitaFeignClientBuilderImpl
implements BonitaFeignClientBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BonitaFeignClientBuilderImpl.class);
    @NonNull
    private final String url;
    private int connectTimeoutInSeconds = 10;
    private int readTimeoutInSeconds = 10;
    private int writeTimeoutInSeconds = 10;
    private boolean disableRetry = false;
    private boolean disableCertificateCheck = false;
    private Feign.Builder feignBuilder;
    private OkHttpClient okHttpClient;
    private ObjectMapper objectMapper;
    private LogContentLevel logContentLevel = LogContentLevel.OFF;

    @Override
    public BonitaClient build() {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(this.url);
        this.okHttpClient = Optional.ofNullable(this.okHttpClient).orElseGet(() -> this.configureHttpClient(new OkHttpClient.Builder()).build());
        this.objectMapper = this.configureJackson(Optional.ofNullable(this.objectMapper).orElseGet(apiClient::getObjectMapper));
        this.feignBuilder = Optional.ofNullable(this.feignBuilder).orElseGet(() -> this.configureFeign(apiClient.getFeignBuilder()));
        apiClient.setFeignBuilder(this.feignBuilder);
        CachingApiProvider apiProvider = new CachingApiProvider(apiClient);
        BonitaCookieAuth authorization = new BonitaCookieAuth();
        apiClient.addAuthorization("bonita", authorization);
        BonitaLoginService loginService = new BonitaLoginService(apiProvider, this.objectMapper, authorization);
        CachingClientContext clientContext = new CachingClientContext();
        DefaultApplicationService applicationService = new DefaultApplicationService(clientContext, apiProvider, this.objectMapper);
        BdmResponseConverter bdmResponseConverter = new BdmResponseConverter(this.objectMapper, apiProvider);
        DefaultBdmService bdmService = new DefaultBdmService(clientContext, apiProvider, bdmResponseConverter);
        DefaultUserService userService = new DefaultUserService(clientContext, apiProvider, this.objectMapper);
        DefaultProcessService processService = new DefaultProcessService(clientContext, apiProvider, this.objectMapper);
        DefaultSystemService systemService = new DefaultSystemService(clientContext, apiProvider, this.objectMapper);
        HttpBearerAuth bearerAuth = (HttpBearerAuth)apiClient.getAuthorization("bearer_auth");
        return new BonitaFeignClient(apiClient.getBasePath(), apiProvider, loginService, applicationService, bdmService, userService, processService, systemService, bearerAuth);
    }

    Feign.Builder configureFeign(Feign.Builder feignBuilder) {
        log.debug("Configuring Feign builder ...");
        return feignBuilder.client((Client)new feign.okhttp.OkHttpClient(this.okHttpClient)).options(new Request.Options((long)this.okHttpClient.connectTimeoutMillis(), TimeUnit.MILLISECONDS, (long)this.okHttpClient.readTimeoutMillis(), TimeUnit.MILLISECONDS, this.okHttpClient.followRedirects())).decoder((Decoder)new DelegatingDecoder().register("application/json", (Decoder)new ApiResponseDecoder(this.objectMapper))).errorDecoder((ErrorDecoder)new BonitaErrorDecoder()).requestInterceptor((RequestInterceptor)new BonitaCharsetBugInterceptor()).retryer((Retryer)(this.disableRetry ? Retryer.NEVER_RETRY : new Retryer.Default()));
    }

    ObjectMapper configureJackson(ObjectMapper objectMapper) {
        log.debug("Configuring Object mapper ...");
        objectMapper.findAndRegisterModules().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configOverride(Map.class).setInclude(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.ALWAYS, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        return objectMapper;
    }

    OkHttpClient.Builder configureHttpClient(OkHttpClient.Builder builder) {
        log.debug("Configuring OkHttp client ...");
        OkHttpClient.Builder okHttpClientBuilder = this.addTrustAllCertificateManagerIfNeeded(builder).connectTimeout((long)this.connectTimeoutInSeconds, TimeUnit.SECONDS).readTimeout((long)this.readTimeoutInSeconds, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeoutInSeconds, TimeUnit.SECONDS).followRedirects(Boolean.TRUE.booleanValue());
        if (!LogContentLevel.OFF.equals((Object)this.logContentLevel)) {
            HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor(message -> LoggerFactory.getLogger(BonitaClient.class).info(message));
            switch (this.logContentLevel) {
                case FULL: {
                    logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                    break;
                }
                case HEADER: {
                    logInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                    break;
                }
                default: {
                    logInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                }
            }
            okHttpClientBuilder.addInterceptor((Interceptor)logInterceptor);
        }
        return okHttpClientBuilder;
    }

    OkHttpClient.Builder addTrustAllCertificateManagerIfNeeded(OkHttpClient.Builder builder) {
        if (this.disableCertificateCheck) {
            log.debug("Configuring client Certificate manager ...");
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{this.newTrustAllCertManager()};
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
                builder.hostnameVerifier((hostname, session) -> true);
            }
            catch (Exception e) {
                throw new ClientException("An internal error has occurred while building the insecure HttpClient", e);
            }
            log.warn("Certificate Manager is configured to trust all ! (no check)");
        }
        return builder;
    }

    @NotNull
    TrustManager newTrustAllCertManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    @Generated
    public BonitaFeignClientBuilderImpl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl connectTimeoutInSeconds(int connectTimeoutInSeconds) {
        this.connectTimeoutInSeconds = connectTimeoutInSeconds;
        return this;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl readTimeoutInSeconds(int readTimeoutInSeconds) {
        this.readTimeoutInSeconds = readTimeoutInSeconds;
        return this;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl writeTimeoutInSeconds(int writeTimeoutInSeconds) {
        this.writeTimeoutInSeconds = writeTimeoutInSeconds;
        return this;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl disableRetry(boolean disableRetry) {
        this.disableRetry = disableRetry;
        return this;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl disableCertificateCheck(boolean disableCertificateCheck) {
        this.disableCertificateCheck = disableCertificateCheck;
        return this;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl feignBuilder(Feign.Builder feignBuilder) {
        this.feignBuilder = feignBuilder;
        return this;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl okHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    @Override
    @Generated
    public BonitaFeignClientBuilderImpl logContentLevel(LogContentLevel logContentLevel) {
        this.logContentLevel = logContentLevel;
        return this;
    }
}

