/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import java.io.File;
import lombok.Generated;
import org.bonitasoft.web.client.exception.ClientException;
import org.bonitasoft.web.client.services.impl.xml.XmlDocumentParser;
import org.bonitasoft.web.client.services.utils.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

final class BusinessArchiveInfo {
    private static final String PROCESS_DESIGN_FILENAME = "process-design.xml";
    private final String processName;
    private final String processVersion;
    private final File archive;

    static BusinessArchiveInfo readFrom(File bar) {
        try {
            byte[] fileFromZip = FileUtils.getFileFromZip(bar, PROCESS_DESIGN_FILENAME);
            XmlDocumentParser documentParser = new XmlDocumentParser();
            Document doc = documentParser.parse(fileFromZip);
            NamedNodeMap attributes = doc.getFirstChild().getAttributes();
            return BusinessArchiveInfo.builder().archive(bar).processName(attributes.getNamedItem("name").getNodeValue()).processVersion(attributes.getNamedItem("version").getNodeValue()).build();
        }
        catch (Exception e) {
            throw new ClientException("Unable to parse bar file", e);
        }
    }

    @Generated
    BusinessArchiveInfo(String processName, String processVersion, File archive) {
        this.processName = processName;
        this.processVersion = processVersion;
        this.archive = archive;
    }

    @Generated
    public static BusinessArchiveInfoBuilder builder() {
        return new BusinessArchiveInfoBuilder();
    }

    @Generated
    public String getProcessName() {
        return this.processName;
    }

    @Generated
    public String getProcessVersion() {
        return this.processVersion;
    }

    @Generated
    public File getArchive() {
        return this.archive;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessArchiveInfo)) {
            return false;
        }
        BusinessArchiveInfo other = (BusinessArchiveInfo)o;
        String this$processName = this.getProcessName();
        String other$processName = other.getProcessName();
        if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
            return false;
        }
        String this$processVersion = this.getProcessVersion();
        String other$processVersion = other.getProcessVersion();
        if (this$processVersion == null ? other$processVersion != null : !this$processVersion.equals(other$processVersion)) {
            return false;
        }
        File this$archive = this.getArchive();
        File other$archive = other.getArchive();
        return !(this$archive == null ? other$archive != null : !((Object)this$archive).equals(other$archive));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $processName = this.getProcessName();
        result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
        String $processVersion = this.getProcessVersion();
        result = result * 59 + ($processVersion == null ? 43 : $processVersion.hashCode());
        File $archive = this.getArchive();
        result = result * 59 + ($archive == null ? 43 : ((Object)$archive).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BusinessArchiveInfo(processName=" + this.getProcessName() + ", processVersion=" + this.getProcessVersion() + ", archive=" + String.valueOf(this.getArchive()) + ")";
    }

    @Generated
    public static class BusinessArchiveInfoBuilder {
        @Generated
        private String processName;
        @Generated
        private String processVersion;
        @Generated
        private File archive;

        @Generated
        BusinessArchiveInfoBuilder() {
        }

        @Generated
        public BusinessArchiveInfoBuilder processName(String processName) {
            this.processName = processName;
            return this;
        }

        @Generated
        public BusinessArchiveInfoBuilder processVersion(String processVersion) {
            this.processVersion = processVersion;
            return this;
        }

        @Generated
        public BusinessArchiveInfoBuilder archive(File archive) {
            this.archive = archive;
            return this;
        }

        @Generated
        public BusinessArchiveInfo build() {
            return new BusinessArchiveInfo(this.processName, this.processVersion, this.archive);
        }

        @Generated
        public String toString() {
            return "BusinessArchiveInfo.BusinessArchiveInfoBuilder(processName=" + this.processName + ", processVersion=" + this.processVersion + ", archive=" + String.valueOf(this.archive) + ")";
        }
    }
}

