/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.extension.rest;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import org.bonitasoft.web.extension.rest.RestApiResponse;

public class RestApiResponseBuilder
extends org.bonitasoft.console.common.server.page.RestApiResponseBuilder {
    private int pageIndex = -1;
    private int pageSize = -1;
    private long totalSize = -1L;

    @Override
    public RestApiResponseBuilder withResponse(Serializable response) {
        this.response = response;
        return this;
    }

    @Override
    public RestApiResponseBuilder withResponseStatus(int httpStatus) {
        this.httpStatus = httpStatus;
        return this;
    }

    @Override
    public RestApiResponseBuilder withAdditionalHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
        return this;
    }

    @Override
    public RestApiResponseBuilder withAdditionalCookie(Cookie cookie) {
        this.additionalCookies.add(cookie);
        return this;
    }

    @Override
    public RestApiResponseBuilder withCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    @Override
    public RestApiResponseBuilder withMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public RestApiResponseBuilder withContentRange(int pageIndex, int pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        return this;
    }

    public RestApiResponseBuilder withContentRange(int pageIndex, int pageSize, long totalSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalSize = totalSize;
        return this;
    }

    @Override
    public RestApiResponse build() {
        if (this.pageIndex >= 0 && this.pageSize >= 0) {
            this.additionalHeaders.put("Content-Range", String.format("%s-%s/%s", this.pageIndex, this.pageSize, this.totalSize >= 0L ? Long.valueOf(this.totalSize) : "*"));
        }
        return new RestApiResponse(this.response, this.httpStatus, this.additionalHeaders, this.additionalCookies, this.mediaType, this.characterSet);
    }
}

