/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.AbstractRepository;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.WidgetContainerRepository;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.repository.BeanValidator;

public class FragmentRepository
extends AbstractRepository<Fragment>
implements WidgetContainerRepository<Fragment> {
    public FragmentRepository(Path fragmentsPath, Path templateResourcesPath, JsonFileBasedPersister<Fragment> persister, JsonFileBasedLoader<Fragment> loader, BeanValidator validator, Watcher watcher) {
        super(fragmentsPath, persister, loader, validator, watcher, templateResourcesPath);
    }

    @Override
    public String getComponentName() {
        return "fragment";
    }

    public List<Fragment> getAllNotUsingElement(String id) {
        List<String> fragmentsUsingElement = this.getFragmentsUsingElement(id);
        return this.getAll().stream().filter(fragment -> !fragmentsUsingElement.contains(fragment.getId())).collect(Collectors.toList());
    }

    private List<String> getFragmentsUsingElement(String id) {
        ArrayList<String> fragIds = new ArrayList<String>();
        fragIds.add(id);
        for (Fragment fragment : this.findByObjectId(id)) {
            fragIds.addAll(this.getFragmentsUsingElement(fragment.getId()));
        }
        return fragIds;
    }

    @Override
    public List<Fragment> getArtifactsUsingWidget(String widgetId) {
        return this.findByObjectId(widgetId);
    }

    @Override
    public Map<String, List<Fragment>> getArtifactsUsingWidgets(List<String> widgetIds) {
        return this.findByObjectIds(widgetIds);
    }

    public List<Fragment> getByIds(Set<String> fragmentsId) {
        ArrayList<Fragment> result = new ArrayList<Fragment>();
        for (String fragmentId : fragmentsId) {
            result.add((Fragment)this.get(fragmentId));
        }
        return result;
    }
}

