/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.AbstractRepository;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.RefreshingRepository;
import org.bonitasoft.web.designer.common.repository.WidgetContainerRepository;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRepository
extends AbstractRepository<Page>
implements RefreshingRepository,
WidgetContainerRepository<Page> {
    public static final String METADATA = ".metadata";
    private static final Logger logger = LoggerFactory.getLogger(PageRepository.class);

    public PageRepository(Path pagesPath, Path templateResourcesPath, JsonFileBasedPersister<Page> persister, JsonFileBasedLoader<Page> loader, BeanValidator validator, Watcher watcher) {
        super(pagesPath, persister, loader, validator, watcher, templateResourcesPath);
    }

    @Override
    public String getComponentName() {
        return "page";
    }

    @Override
    public List<Page> getArtifactsUsingWidget(String widgetId) {
        return this.findByObjectId(widgetId);
    }

    @Override
    public Map<String, List<Page>> getArtifactsUsingWidgets(List<String> widgetIds) {
        return this.findByObjectIds(widgetIds);
    }

    @Override
    public void refresh(String id) {
        try {
            Page page = (Page)this.get(id);
            Path metadataPath = this.persister.updateMetadata(this.path.resolve(page.getId()), page);
            this.persister.saveInIndex(metadataPath, page);
        }
        catch (RepositoryException e) {
            logger.error("Cannot read page {}. Maybe a migration is required.", (Object)id, (Object)e);
        }
        catch (IOException e) {
            logger.error("Cannot update index file.", (Throwable)e);
        }
    }

    public void refreshIndexing(List<Page> pages) {
        try {
            this.persister.refreshIndexing(this.path.resolve(METADATA), pages);
        }
        catch (Exception e) {
            logger.error("Cannot refresh workspace indexing.", (Throwable)e);
        }
    }
}

