/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class AssetVisitor
implements ElementVisitor<Set<Asset>> {
    private final WidgetRepository widgetRepository;
    private final FragmentRepository fragmentRepository;

    public AssetVisitor(WidgetRepository widgetRepository, FragmentRepository fragmentRepository) {
        this.widgetRepository = widgetRepository;
        this.fragmentRepository = fragmentRepository;
    }

    public Set<Asset> visit(FragmentElement fragmentElement) {
        return this.visitRows(((Fragment)this.fragmentRepository.get(fragmentElement.getId())).getRows());
    }

    public Set<Asset> visit(Container container) {
        HashSet<Asset> assets = new HashSet<Asset>();
        assets.addAll(this.linkAssetToComponent(container.getId()));
        assets.addAll(this.visitRows(container.getRows()));
        return assets;
    }

    public Set<Asset> visit(FormContainer formContainer) {
        HashSet<Asset> assets = new HashSet<Asset>();
        assets.addAll(this.linkAssetToComponent(formContainer.getId()));
        assets.addAll((Collection)formContainer.getContainer().accept((ElementVisitor)this));
        return assets;
    }

    public Set<Asset> visit(TabsContainer tabsContainer) {
        HashSet<Asset> assets = new HashSet<Asset>();
        assets.addAll(this.linkAssetToComponent(tabsContainer.getId()));
        for (TabContainer tabContainer : tabsContainer.getTabList()) {
            assets.addAll((Collection)tabContainer.accept((ElementVisitor)this));
        }
        return assets;
    }

    public Set<Asset> visit(TabContainer tabContainer) {
        return new HashSet<Asset>((Collection)tabContainer.getContainer().accept((ElementVisitor)this));
    }

    public Set<Asset> visit(Component component) {
        Widget widget = (Widget)this.widgetRepository.get(component.getId());
        for (Asset asset : widget.getAssets()) {
            asset.setComponentId(widget.getId());
            asset.setScope("widget");
        }
        return widget.getAssets();
    }

    public Set<Asset> visit(Widget widget) {
        for (Asset asset : widget.getAssets()) {
            asset.setScope("widget");
        }
        return widget.getAssets();
    }

    public Set<Asset> visit(ModalContainer modalContainer) {
        HashSet<Asset> assets = new HashSet<Asset>();
        assets.addAll(this.linkAssetToComponent(modalContainer.getId()));
        assets.addAll((Collection)modalContainer.getContainer().accept((ElementVisitor)this));
        return assets;
    }

    private List<Asset> linkAssetToComponent(String id) {
        Widget widget = (Widget)this.widgetRepository.get(id);
        return widget.getAssets().stream().map(asset -> {
            asset.setComponentId(widget.getId());
            asset.setScope("widget");
            return asset;
        }).collect(Collectors.toList());
    }

    public <P extends Previewable & Identifiable> Set<Asset> visit(P previewable) {
        HashSet<Asset> assets = new HashSet<Asset>();
        if (previewable instanceof Assetable) {
            Set pageAssets = ((Assetable)previewable).getAssets();
            assets.addAll(pageAssets.stream().map(asset -> asset.setScope("page")).collect(Collectors.toSet()));
            assets.addAll(this.visitRows(previewable.getRows()));
            for (Asset asset2 : assets) {
                if (asset2.getId() != null) {
                    asset2.setActive(!previewable.getInactiveAssets().contains(asset2.getId()));
                    continue;
                }
                asset2.setActive(!previewable.getInactiveAssets().contains(asset2.getName()));
            }
        }
        return assets;
    }

    protected Set<Asset> visitRows(List<List<Element>> rows) {
        HashSet<Asset> assets = new HashSet<Asset>();
        for (List<Element> elements : rows) {
            for (Element element : elements) {
                assets.addAll((Collection)element.accept((ElementVisitor)this));
            }
        }
        return assets;
    }
}

