/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.visitor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class FragmentIdVisitor
implements ElementVisitor<Set<String>> {
    private final FragmentRepository fragmentRepository;

    public Set<String> visit(Container container) {
        return this.getFragmentIdsFrom(container.getRows());
    }

    public Set<String> visit(FormContainer formContainer) {
        return (Set)formContainer.getContainer().accept((ElementVisitor)this);
    }

    public Set<String> visit(TabsContainer tabsContainer) {
        HashSet<String> fragmentIds = new HashSet<String>();
        for (TabContainer tabContainer : tabsContainer.getTabList()) {
            fragmentIds.addAll((Collection)tabContainer.accept((ElementVisitor)this));
        }
        return fragmentIds;
    }

    public Set<String> visit(ModalContainer modalContainer) {
        return (Set)modalContainer.getContainer().accept((ElementVisitor)this);
    }

    public Set<String> visit(TabContainer tabContainer) {
        return (Set)tabContainer.getContainer().accept((ElementVisitor)this);
    }

    public Set<String> visit(FragmentElement fragmentElement) {
        Set<String> fragmentIds = this.getFragmentIdsFrom(((Fragment)this.fragmentRepository.get(fragmentElement.getId())).getRows());
        fragmentIds.add(fragmentElement.getId());
        return fragmentIds;
    }

    public Set<String> visit(Component component) {
        return Collections.emptySet();
    }

    public Set<String> visit(Previewable previewable) {
        return this.getFragmentIdsFrom(previewable.getRows());
    }

    private Set<String> getFragmentIdsFrom(List<List<Element>> rows) {
        HashSet<String> fragmentIds = new HashSet<String>();
        for (List<Element> row : rows) {
            for (Element element : row) {
                fragmentIds.addAll((Collection)element.accept((ElementVisitor)this));
            }
        }
        return fragmentIds;
    }

    public FragmentIdVisitor(FragmentRepository fragmentRepository) {
        this.fragmentRepository = fragmentRepository;
    }
}

