/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper
implements AutoCloseable {
    public static final PathPredicate ALL_DIRECTORIES = path -> true;
    public static final FilePredicate ALL_FILES = file -> true;
    private final ZipOutputStream zip;

    public Zipper(OutputStream destStream) {
        this.zip = new ZipOutputStream(destStream);
    }

    public void addToZip(byte[] bytes, String destFilename) throws IOException {
        this.zip.putNextEntry(new ZipEntry(destFilename));
        this.zip.write(bytes);
        this.zip.closeEntry();
    }

    public void addToZip(Path path, String destFilename) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        this.addToZip(bytes, destFilename);
    }

    public void addDirectoryToZip(final Path sourceDirectory, final PathPredicate directoryPredicate, final FilePredicate filePredicate, final String destinationDirectoryName) throws IOException {
        Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!directoryPredicate.accept(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (filePredicate.accept(file.toFile())) {
                    Zipper.this.addToZip(file, Zipper.this.normalizeZipEntryName(Paths.get(destinationDirectoryName, new String[0]).resolve(sourceDirectory.relativize(file))));
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.zip.flush();
        this.zip.close();
    }

    private String normalizeZipEntryName(Path path) {
        return path.toString().replace(File.separator, "/");
    }

    public static interface FilePredicate {
        public boolean accept(File var1);
    }

    public static interface PathPredicate {
        public boolean accept(Path var1);
    }
}

