/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.livebuild;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.bonitasoft.web.designer.common.livebuild.PathListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverFactory {
    private static final Logger logger = LoggerFactory.getLogger(ObserverFactory.class);

    public FileAlterationObserver create(Path path, final PathListener listener) {
        FileAlterationObserver observer = new FileAlterationObserver(path.toFile());
        observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onFileChange(File file) {
                if (file.length() > 0L) {
                    ObserverFactory.this.triggerChange(file, listener);
                }
            }

            public void onFileCreate(File file) {
                ObserverFactory.this.triggerChange(file, listener);
            }
        });
        return observer;
    }

    private void triggerChange(File file, PathListener listener) {
        try {
            listener.onChange(file.toPath());
        }
        catch (Exception e) {
            logger.error("Unexpected exception while processing file {}", (Object)file.getPath(), (Object)e);
        }
    }
}

