/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bonitasoft.web.designer.common.repository.AbstractLoader;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileBasedLoader<T extends Identifiable>
extends AbstractLoader<T> {
    protected static final Logger logger = LoggerFactory.getLogger(JsonFileBasedLoader.class);
    protected Class<T> type;

    public JsonFileBasedLoader(JsonHandler jsonHandler, Class<T> type) {
        super(jsonHandler, type);
        this.type = type;
    }

    @Override
    public List<T> findByObjectId(Path directory, String objectId) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(objectId);
        Map<String, List<T>> map = this.findByObjectIds(directory, ids);
        List<T> objects = map.get(objectId);
        return Objects.requireNonNullElse(objects, Collections.emptyList());
    }

    @Override
    public Map<String, List<T>> findByObjectIds(Path directory, List<String> objectIds) throws IOException {
        if (!Files.exists(directory, new LinkOption[0]) || objectIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, "[!.]*");){
            for (Path componentDirectory : directoryStream) {
                Identifiable object;
                String id;
                Path componentFile = componentDirectory.resolve((id = componentDirectory.getFileName().toString()) + ".json");
                if (!Files.exists(componentFile, new LinkOption[0])) continue;
                String content = new String(Files.readAllBytes(componentFile), StandardCharsets.UTF_8);
                String contentWithoutSpaces = this.removeSpaces(content);
                try {
                    object = (Identifiable)this.jsonHandler.fromJson(content.getBytes(StandardCharsets.UTF_8), this.type);
                }
                catch (IOException ex) {
                    throw new IOException("Json mapping error for " + componentFile, ex);
                }
                for (String objectId : objectIds) {
                    Path objectPath = this.resolve(directory, objectId);
                    if (objectPath != null && (objectPath.equals(componentFile) || !Files.exists(componentFile, new LinkOption[0]) || !contentWithoutSpaces.contains(String.format("\"id\":\"%s\"", objectId)))) continue;
                    List objects = map.computeIfAbsent(objectId, k -> new ArrayList());
                    objects.add(object);
                }
            }
        }
        return map;
    }

    @Override
    public T getByUUID(Path directory, String uuid) throws IOException {
        Path indexPath = directory.resolve(".metadata/.index.json");
        if (indexPath.toFile().exists()) {
            Path componentFile;
            byte[] indexFileContent = Files.readAllBytes(indexPath);
            Map index = this.jsonHandler.fromJsonToMap(indexFileContent);
            String objectId = (String)index.get(uuid);
            if (objectId != null && (componentFile = directory.resolve(String.format("%s/%s.json", objectId, objectId))).toFile().exists()) {
                return (T)((Identifiable)this.jsonHandler.fromJson(Files.readAllBytes(componentFile), this.type));
            }
        } else {
            logger.info("index file not found [{}]. It will be created when needed of by the migration.", (Object)indexPath);
        }
        return null;
    }

    @Override
    public boolean contains(Path directory, String objectId) throws IOException {
        Path objectPath = this.resolve(directory, objectId);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, "*");){
            for (Path componentDirectory : directoryStream) {
                byte[] content;
                String id = componentDirectory.getFileName().toString();
                Path componentFile = componentDirectory.resolve(id + ".json");
                if (objectPath != null && objectPath.equals(componentFile) || this.indexOf(content = Files.readAllBytes(componentFile), objectId.getBytes(StandardCharsets.UTF_8)) < 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected int indexOf(byte[] file, byte[] occurence) {
        if (file != null && occurence != null) {
            int len = occurence.length;
            int limit = file.length - len;
            for (int i = 0; i <= limit; ++i) {
                int k;
                for (k = 0; k < len && occurence[k] == file[i + k]; ++k) {
                }
                if (k != len) continue;
                return i;
            }
        }
        return -1;
    }

    private String removeSpaces(String text) {
        return text.replaceAll("\\s+", "");
    }
}

