/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import com.fasterxml.jackson.core.JsonGenerationException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.common.migration.Version;
import org.bonitasoft.web.designer.model.HasUUID;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonViewMetadata;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileBasedPersister<T extends Identifiable> {
    public static final String INDEX_METADATA = ".index";
    protected static final Logger logger = LoggerFactory.getLogger(JsonFileBasedPersister.class);
    protected JsonHandler jsonHandler;
    protected BeanValidator validator;
    protected String version;
    protected String modelVersion;

    public JsonFileBasedPersister(JsonHandler jsonHandler, BeanValidator validator, String version, String modelVersion) {
        this.jsonHandler = jsonHandler;
        this.validator = validator;
        this.version = version;
        this.modelVersion = modelVersion;
    }

    public void save(Path directory, T content) throws IOException {
        String versionToSet = this.version;
        if (versionToSet != null) {
            String[] currentVersion = versionToSet.split("_");
            versionToSet = currentVersion[0];
        }
        content.setDesignerVersionIfEmpty(versionToSet);
        String artifactVersion = content.getArtifactVersion();
        if (artifactVersion == null || Version.isSupportingModelVersion(artifactVersion)) {
            content.setModelVersionIfEmpty(this.modelVersion);
        }
        this.validator.validate(content);
        try {
            Files.write(this.jsonFile(directory, content.getId()), this.jsonHandler.toPrettyJson(content, JsonViewPersistence.class), new OpenOption[0]);
            Path metadataPath = this.updateMetadata(directory, content);
            if (content instanceof HasUUID && !StringUtils.isEmpty((CharSequence)((HasUUID)content).getUUID())) {
                this.saveInIndex(metadataPath, content);
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public Path updateMetadata(Path directory, T content) throws IOException {
        Path metadataPath = directory.getParent().resolve(".metadata");
        FileUtils.forceMkdir((File)metadataPath.toFile());
        Files.write(this.jsonFile(metadataPath, content.getId()), this.jsonHandler.toJson(content, JsonViewMetadata.class), new OpenOption[0]);
        return metadataPath;
    }

    public synchronized void saveInIndex(Path metadataPath, T content) throws IOException {
        Path indexPath = this.jsonFile(metadataPath, INDEX_METADATA);
        Map<String, String> index = this.loadIndex(indexPath);
        try {
            if (this.getUUIDIfExist(content) != null) {
                index.put(this.getUUIDIfExist(content), content.getId());
            }
            this.writeIndexFile(indexPath, index);
        }
        catch (JsonGenerationException e) {
            logger.error("Cannot generate index for file {}. Maybe a migration is required.", (Object)content.getId());
        }
    }

    private synchronized void writeIndexFile(Path indexPath, Map<String, String> index) throws IOException {
        try {
            if (!indexPath.getParent().toFile().exists()) {
                FileUtils.forceMkdir((File)indexPath.getParent().toFile());
            }
            Files.write(indexPath, this.jsonHandler.toJson(index), new OpenOption[0]);
        }
        catch (JsonGenerationException e) {
            logger.error("Cannot generate index. Maybe a migration is required.");
        }
    }

    private synchronized Map<String, String> loadIndex(Path indexPath) throws IOException {
        Map<String, String> index;
        block3: {
            index = new HashMap<String, String>();
            if (indexPath.toFile().exists()) {
                byte[] indexFileContent = Files.readAllBytes(indexPath);
                try {
                    index = this.jsonHandler.fromJsonToMap(indexFileContent);
                }
                catch (Exception e) {
                    if (indexFileContent.length <= 0) break block3;
                    logger.error("Failed to parse '{}' file with content:\n{}", new Object[]{indexPath, new String(indexFileContent, StandardCharsets.UTF_8), e});
                }
            }
        }
        return index;
    }

    private String getUUIDIfExist(T content) {
        String uuid = ((HasUUID)content).getUUID();
        if (uuid != null && !uuid.isEmpty()) {
            return uuid;
        }
        return null;
    }

    protected void removeFromIndex(Path metadataPath, T content) throws IOException {
        Path indexPath = this.jsonFile(metadataPath, INDEX_METADATA);
        if (indexPath.toFile().exists()) {
            byte[] indexFileContent = Files.readAllBytes(indexPath);
            Map index = this.jsonHandler.fromJsonToMap(indexFileContent);
            String uuidInIndex = ((HasUUID)content).getUUID();
            String idInIndex = (String)index.get(uuidInIndex);
            if (content.getId().equals(idInIndex)) {
                index.remove(uuidInIndex);
            }
            Files.write(indexPath, this.jsonHandler.toJson(index), new OpenOption[0]);
        }
    }

    public void delete(Path directory, T content) throws IOException {
        try {
            Path metadataPath = directory.getParent().resolve(".metadata");
            FileUtils.deleteQuietly((File)metadataPath.resolve(String.format("%s.json", content.getId())).toFile());
            FileUtils.deleteDirectory((File)directory.toFile());
            if (content instanceof HasUUID) {
                this.removeFromIndex(metadataPath, content);
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public Path jsonFile(Path directory, String id) {
        return directory.resolve(id + ".json");
    }

    public synchronized void refreshIndexing(Path metadataFolder, List<T> pages) throws IOException {
        Path indexPath = this.jsonFile(metadataFolder, INDEX_METADATA);
        HashMap<String, String> refreshingIndex = new HashMap<String, String>();
        pages.forEach(page -> {
            String uuidIfExist = this.getUUIDIfExist(page);
            if (uuidIfExist != null) {
                refreshingIndex.put(uuidIfExist, page.getId());
            }
        });
        this.writeIndexFile(indexPath, refreshingIndex);
    }
}

