/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bonitasoft.web.designer.common.repository.Loader;
import org.bonitasoft.web.designer.common.repository.exception.JsonReadException;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoader<T extends Identifiable>
implements Loader<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLoader.class);
    private final Class<T> type;
    protected JsonHandler jsonHandler;

    protected AbstractLoader(JsonHandler jsonHandler, Class<T> type) {
        this.jsonHandler = jsonHandler;
        this.type = type;
    }

    @Override
    public T get(Path path) {
        try {
            Identifiable artifact = (Identifiable)this.jsonHandler.fromJson(Files.readAllBytes(path), this.type);
            return (T)this.applyMetadata(path, artifact);
        }
        catch (JsonProcessingException e) {
            throw new JsonReadException(String.format("Could not read json file [%s]", path.getFileName()), (Exception)((Object)e));
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException(String.format("File not found: [%s]", path.getFileName()));
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting component (on file [%s])", path.getFileName()), e);
        }
    }

    protected T applyMetadata(Path path, T artifact) throws IOException {
        Path metadata = path.getParent().getParent().resolve(String.format(".metadata/%s.json", path.getParent().getFileName()));
        if (Files.exists(metadata, new LinkOption[0])) {
            try {
                byte[] content = Files.readAllBytes(metadata);
                this.jsonHandler.checkValidJson(content);
                artifact = (Identifiable)this.jsonHandler.assign(artifact, content);
            }
            catch (IOException e) {
                logger.warn("Cannot apply metadata to {}. {} is not a valid Json file.", (Object)path, (Object)metadata);
            }
        }
        return artifact;
    }

    private Optional<T> tryGet(Path path) {
        try {
            return Optional.of(this.get(path));
        }
        catch (JsonReadException | NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public List<T> getAll(Path directory) throws IOException {
        return this.getAll(directory, "[!.]*");
    }

    protected List<T> getAll(Path directory, String glob) throws IOException {
        ArrayList<Identifiable> objects = new ArrayList<Identifiable>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, glob);){
            for (Path path : directoryStream) {
                String id = this.getComponentId(path);
                Optional<T> e = this.tryGet(directory.resolve(String.format("%s/%s.json", id, id)));
                if (e.isPresent()) {
                    objects.add((Identifiable)e.get());
                    continue;
                }
                logger.error("{} {} cannot be loaded, your repository may be corrupted", (Object)this.type.getSimpleName(), (Object)id);
            }
        }
        return objects;
    }

    @Override
    public String getNextAvailableObjectId(Path directory, String objectName) throws IOException {
        String nextAvailableObjectId;
        if (!Files.exists(directory.resolve(objectName), new LinkOption[0])) {
            return objectName;
        }
        Pattern pattern = Pattern.compile(objectName + "(\\d+)$");
        try (Stream<Path> directoryStream = Files.list(directory);){
            OptionalInt maxInt = directoryStream.map(directoryPath -> pattern.matcher(directoryPath.getFileName().toString())).filter(Matcher::find).mapToInt(m -> Integer.parseInt(m.group(1))).max();
            nextAvailableObjectId = objectName + (maxInt.orElse(0) + 1);
        }
        return nextAvailableObjectId;
    }

    @Override
    public T load(Path path) {
        try {
            return (T)((Identifiable)this.jsonHandler.fromJson(Files.readAllBytes(path), this.type, JsonViewPersistence.class));
        }
        catch (JsonProcessingException e) {
            throw new JsonReadException(String.format("Could not read json file [%s]", path.getFileName()), (Exception)((Object)e));
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException(String.format("File not found: [%s]", path.getFileName()));
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting component (on file [%s])", path.getFileName()), e);
        }
    }

    public Path resolve(Path directory, String id) {
        return directory.resolve(String.format("%s/%s.json", id, id));
    }

    private String getComponentId(Path path) {
        return path.getFileName().toString().replaceAll("\\.\\w+", "");
    }

    @Override
    public List<T> loadAll(Path directory) throws IOException {
        return this.loadAll(directory, "[!.]*");
    }

    protected List<T> loadAll(Path directory, String glob) throws IOException {
        List<T> objects;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, glob);){
            objects = this.loadAll(directory, directoryStream);
        }
        return objects;
    }

    @Override
    public List<T> loadAll(Path directory, DirectoryStream.Filter<Path> filter) throws IOException {
        List<T> objects;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, filter);){
            objects = this.loadAll(directory, directoryStream);
        }
        return objects;
    }

    private List<T> loadAll(Path directory, DirectoryStream<Path> directoryStream) {
        ArrayList<T> objects = new ArrayList<T>();
        for (Path path : directoryStream) {
            String id = this.getComponentId(path);
            objects.add(this.load(this.resolve(directory, id)));
        }
        return objects;
    }
}

