/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.exception.JsonReadException;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetFileBasedLoader
extends JsonFileBasedLoader<Widget> {
    protected static final Logger logger = LoggerFactory.getLogger(WidgetFileBasedLoader.class);

    public WidgetFileBasedLoader(JsonHandler jsonHandler) {
        super(jsonHandler, Widget.class);
    }

    @Override
    public Widget get(Path path) {
        try {
            Widget widget = this.getWidgetWithView(path, null);
            return this.applyMetadata(path, widget);
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting metadata (for file [%s])", path.getFileName()), e);
        }
    }

    private Widget getWidgetWithView(Path path, Class<?> view) {
        try {
            Widget widget = view == null ? (Widget)this.jsonHandler.fromJson(Files.readAllBytes(path), this.type) : (Widget)this.jsonHandler.fromJson(Files.readAllBytes(path), this.type, view);
            widget.prepareWidgetToDeserialize(path.getParent());
            return widget;
        }
        catch (JsonProcessingException e) {
            throw new JsonReadException(String.format("Could not read json file [%s]", path.getFileName()), (Exception)((Object)e));
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException(String.format("Could not load component, unexpected structure in the file [%s]", path.getFileName()));
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting component (on file [%s])", path.getFileName()), e);
        }
    }

    @Override
    public List<Widget> findByObjectId(Path directory, String objectId) throws IOException {
        ArrayList<Widget> findIn = new ArrayList<Widget>();
        List widgets = this.getAll(directory);
        for (Widget otherWidget : widgets) {
            if (!otherWidget.getTemplate().contains("<" + Widget.spinalCase((String)objectId))) continue;
            findIn.add(otherWidget);
        }
        return findIn;
    }

    @Override
    public boolean contains(Path directory, String widgetId) throws IOException {
        return Files.exists(directory.resolve(widgetId).resolve(widgetId + ".json"), new LinkOption[0]);
    }

    @Override
    public Widget getByUUID(Path directory, String uuid) throws IOException {
        return null;
    }

    @Override
    public Widget load(Path path) {
        return this.getWidgetWithView(path, JsonViewPersistence.class);
    }
}

