/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.AbstractRepository;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.exception.InUseException;
import org.bonitasoft.web.designer.common.repository.exception.NotAllowedException;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;

public class WidgetRepository
extends AbstractRepository<Widget> {
    public static final String ANGULARJS_CUSTOM_PREFIX = "custom";
    public static final String ANGULARJS_STANDARD_PREFIX = "pb";
    public static final DirectoryStream.Filter<Path> CUSTOM_WIDGET_FILTER = path -> !path.getFileName().toString().startsWith(ANGULARJS_STANDARD_PREFIX);

    public WidgetRepository(Path widgetsPath, Path templateResourcesPath, JsonFileBasedPersister<Widget> fileBasedRepository, JsonFileBasedLoader<Widget> widgetLoader, BeanValidator validator, Watcher watcher) {
        super(widgetsPath, fileBasedRepository, widgetLoader, validator, watcher, templateResourcesPath);
    }

    @Override
    public String getComponentName() {
        return "widget";
    }

    @Override
    public void delete(String widgetId) throws RepositoryException, NotAllowedException, InUseException {
        Widget widget = (Widget)this.get(widgetId);
        if (!widget.isCustom()) {
            throw new NotAllowedException("We can only delete a custom widget");
        }
        super.delete(widgetId);
    }

    public Widget create(Widget widget) throws IllegalArgumentException {
        String id = ANGULARJS_CUSTOM_PREFIX + StringUtils.trimToEmpty((String)WordUtils.capitalize((String)widget.getName()));
        try {
            Widget existingWidget = (Widget)this.get(id);
            throw new NotAllowedException("Widget with name " + existingWidget.getName() + " already exists");
        }
        catch (NotFoundException e) {
            widget.setCustom(true);
            widget.setId(id);
            this.createComponentDirectory(widget);
            this.updateLastUpdateAndSave(widget);
            return widget;
        }
    }

    public List<Widget> getByIds(Set<String> widgetIds) {
        ArrayList<Widget> result = new ArrayList<Widget>();
        for (String widgetId : widgetIds) {
            result.add((Widget)this.get(widgetId));
        }
        return result;
    }

    public List<Property> addProperty(String widgetId, Property property) {
        Widget widget = (Widget)this.get(widgetId);
        Property existingProperty = widget.getProperty(property.getName());
        if (existingProperty != null) {
            throw new NotAllowedException(String.format("Widget [ %s ] has already a property named %s", widgetId, property.getName()));
        }
        widget.addProperty(property);
        this.updateLastUpdateAndSave(widget);
        return widget.getProperties();
    }

    public List<Property> updateProperty(String widgetId, String propertyName, Property property) {
        Widget widget = (Widget)this.get(widgetId);
        Property existingProperty = widget.getProperty(propertyName);
        if (existingProperty == null) {
            throw new NotFoundException(String.format("Widget [ %s ] has no property named %s", widgetId, propertyName));
        }
        widget.replaceProperty(existingProperty, property);
        this.updateLastUpdateAndSave(widget);
        return widget.getProperties();
    }

    public List<Property> deleteProperty(String widgetId, String propertyName) {
        Widget widget = (Widget)this.get(widgetId);
        Property param = widget.getProperty(propertyName);
        if (param == null) {
            throw new NotFoundException(String.format("Widget [ %s ] has no property named %s", widgetId, propertyName));
        }
        widget.deleteProperty(param);
        this.updateLastUpdateAndSave(widget);
        return widget.getProperties();
    }
}

