/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.common.livebuild.PathListener;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.Loader;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.repository.BeanValidator;

public abstract class AbstractRepository<T extends Identifiable>
implements Repository<T> {
    private final Watcher watcher;
    private final Path templatePath;
    protected JsonFileBasedPersister<T> persister;
    protected Path path;
    protected BeanValidator validator;
    protected Loader<T> loader;

    protected AbstractRepository(Path path, JsonFileBasedPersister<T> persister, Loader<T> loader, BeanValidator validator, Watcher watcher, Path templatePath) {
        this.path = path;
        this.persister = persister;
        this.validator = validator;
        this.loader = loader;
        this.watcher = watcher;
        this.templatePath = templatePath;
    }

    @Override
    public T get(String id) throws NotFoundException, RepositoryException {
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException("Id can not be null when loading a component");
        }
        try {
            return this.loader.get(this.path.resolve(String.format("%s/%s.json", id, id)));
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException(String.format("Non existing %s [%s]", this.getComponentName(), id));
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting %s [%s]", this.getComponentName(), id), e);
        }
    }

    @Override
    public T getByUUID(String uuid) throws RepositoryException {
        try {
            return this.loader.getByUUID(this.path, uuid);
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting %s with UUID %s", this.getComponentName(), uuid), e);
        }
    }

    @Override
    public T get(Path path) {
        try {
            return this.loader.get(path);
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting %s with path %s", this.getComponentName(), path), e);
        }
    }

    @Override
    public List<T> getAll() throws RepositoryException {
        try {
            return this.loader.getAll(this.path);
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting %ss", this.getComponentName()), e);
        }
    }

    @Override
    public T updateLastUpdateAndSave(T component) throws RepositoryException {
        component.setLastUpdate(Instant.now());
        return this.save(component);
    }

    @Override
    public T save(T component) throws RepositoryException {
        if (StringUtils.isBlank((CharSequence)component.getId())) {
            throw new IllegalArgumentException(String.format("Error while saving %s: No id set.", this.getComponentName()));
        }
        this.validator.validate(component);
        this.createComponentDirectory(component);
        try {
            this.persister.save(this.resolvePathFolder(component.getId()), component);
            return component;
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while saving %s [%s]", this.getComponentName(), component.getId()), e);
        }
    }

    @Override
    public void saveAll(List<T> toBeSaved) throws RepositoryException {
        if (toBeSaved != null) {
            for (Identifiable component : toBeSaved) {
                this.updateLastUpdateAndSave(component);
            }
        }
    }

    @Override
    public List<T> findByObjectId(String id) throws RepositoryException {
        try {
            return this.loader.findByObjectId(this.path, id);
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while searching %ss using an object", this.getComponentName()), e);
        }
    }

    @Override
    public Map<String, List<T>> findByObjectIds(List<String> ids) throws RepositoryException {
        try {
            return this.loader.findByObjectIds(this.path, ids);
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while searching %ss using an object", this.getComponentName()), e);
        }
    }

    @Override
    public Path resolvePath(String id) {
        return this.path.resolve(id);
    }

    @Override
    public void delete(String id) throws NotFoundException, RepositoryException {
        T component = this.get(id);
        try {
            this.persister.delete(this.resolvePathFolder(component.getId()), component);
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while deleting %s [%s]", this.getComponentName(), id), e);
        }
    }

    @Override
    public Path resolvePathFolder(String id) {
        return this.resolvePath(id);
    }

    public void createComponentDirectory(T component) {
        try {
            Path componentDirectory = this.path.resolve(component.getId());
            if (!Files.exists(componentDirectory, new LinkOption[0])) {
                Files.createDirectories(componentDirectory, new FileAttribute[0]);
                this.initializeComponentDirectoryFromTemplate(component);
            }
        }
        catch (IOException ex) {
            throw new RepositoryException(String.format("Impossible to create the folder to save the component [ %s ] : %s", component.getId(), this.path), ex);
        }
    }

    private void initializeComponentDirectoryFromTemplate(T component) {
        Path componentTemplateDir = this.templatePath.resolve(this.getComponentName());
        if (Files.exists(componentTemplateDir, new LinkOption[0])) {
            try {
                FileUtils.copyDirectory((File)componentTemplateDir.toFile(), (File)this.resolvePath(component.getId()).toFile());
            }
            catch (IOException e) {
                throw new RepositoryException(String.format("Failed to initialize %s [%s] from template\"", this.getComponentName(), component.getId()), e);
            }
        }
    }

    @Override
    public boolean exists(String id) {
        return Files.exists(this.resolvePath(id).resolve(id + ".json"), new LinkOption[0]);
    }

    @Override
    public void walk(FileVisitor<? super Path> visitor) throws IOException {
        Files.walkFileTree(this.path, visitor);
    }

    @Override
    public void watch(PathListener pathListener) throws IOException {
        this.watcher.watch(this.path, pathListener);
    }

    @Override
    public T markAsFavorite(String id) {
        T component = this.get(id);
        component.setFavorite(true);
        return this.save(component);
    }

    @Override
    public T unmarkAsFavorite(String id) {
        T component = this.get(id);
        component.setFavorite(false);
        return this.save(component);
    }

    @Override
    public String getNextAvailableId(String name) {
        try {
            return this.loader.getNextAvailableObjectId(this.path, name);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to generate object ID", e);
        }
    }

    public JsonFileBasedPersister<T> getPersister() {
        return this.persister;
    }

    @Override
    public T load(Path path) {
        return this.loader.load(path);
    }

    @Override
    public List<T> loadAll(Path directory) throws IOException {
        return this.loader.loadAll(directory);
    }

    @Override
    public List<T> loadAll(Path directory, DirectoryStream.Filter<Path> filter) throws IOException {
        return this.loader.loadAll(directory, filter);
    }
}

