/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.visitor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class WidgetIdVisitor
implements ElementVisitor<Set<String>> {
    private final FragmentRepository fragmentRepository;

    public Set<String> visit(FragmentElement fragmentElement) {
        return this.getWidgetIdsFrom(((Fragment)this.fragmentRepository.get(fragmentElement.getId())).getRows());
    }

    public Set<String> visit(Container container) {
        HashSet<String> widgetIds = new HashSet<String>(this.getWidgetIdsFrom(container.getRows()));
        widgetIds.add(container.getId());
        return widgetIds;
    }

    public Set<String> visit(FormContainer formContainer) {
        HashSet<String> widgetIds = new HashSet<String>((Collection)formContainer.getContainer().accept((ElementVisitor)this));
        widgetIds.add(formContainer.getId());
        return widgetIds;
    }

    public Set<String> visit(TabsContainer tabsContainer) {
        HashSet<String> widgetIds = new HashSet<String>();
        for (TabContainer tabContainer : tabsContainer.getTabList()) {
            widgetIds.addAll((Collection)tabContainer.accept((ElementVisitor)this));
        }
        widgetIds.add(tabsContainer.getId());
        return widgetIds;
    }

    public Set<String> visit(ModalContainer modalContainer) {
        HashSet<String> widgetIds = new HashSet<String>((Collection)modalContainer.getContainer().accept((ElementVisitor)this));
        widgetIds.add(modalContainer.getId());
        return widgetIds;
    }

    public Set<String> visit(TabContainer tabContainer) {
        HashSet<String> widgetIds = new HashSet<String>((Collection)tabContainer.getContainer().accept((ElementVisitor)this));
        widgetIds.add(tabContainer.getId());
        return widgetIds;
    }

    public Set<String> visit(Component component) {
        return Collections.singleton(component.getId());
    }

    public Set<String> visit(Previewable previewable) {
        return this.getWidgetIdsFrom(previewable.getRows());
    }

    protected Set<String> getWidgetIdsFrom(List<List<Element>> rows) {
        HashSet<String> widgetIds = new HashSet<String>();
        for (List<Element> row : rows) {
            for (Element element : row) {
                widgetIds.addAll((Collection)element.accept((ElementVisitor)this));
            }
        }
        return widgetIds;
    }

    public WidgetIdVisitor(FragmentRepository fragmentRepository) {
        this.fragmentRepository = fragmentRepository;
    }
}

