/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.livebuild;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.bonitasoft.web.designer.common.generator.rendering.GenerationException;
import org.bonitasoft.web.designer.common.livebuild.Watcher;

public abstract class AbstractLiveFileBuilder {
    private final Watcher watcher;
    private boolean isLiveBuildEnabled;

    protected AbstractLiveFileBuilder(Watcher watcher, boolean isLiveBuildEnabled) {
        this.watcher = watcher;
        this.isLiveBuildEnabled = isLiveBuildEnabled;
    }

    public void start(Path root) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                AbstractLiveFileBuilder.this.buildIfNeeded(path);
                return FileVisitResult.CONTINUE;
            }
        });
        if (this.isLiveBuildEnabled) {
            this.watcher.watch(root, this::buildIfNeeded);
        }
    }

    private void buildIfNeeded(Path path) {
        if (this.isBuildable(path.toFile().getPath())) {
            try {
                this.build(path);
            }
            catch (Exception ex) {
                throw new GenerationException("Build error for " + path.getFileName(), ex);
            }
        }
    }

    public abstract void build(Path var1) throws IOException;

    public abstract boolean isBuildable(String var1);
}

