/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.common.repository.exception.NotAllowedException;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetScope;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;

public class AssetRepository<T extends Identifiable & Assetable> {
    public static final String COMPONENT_ID_REQUIRED = "The component id is required to add an asset to this component";
    public static final String ASSETS = "assets";
    private final Repository<T> repository;
    private final BeanValidator validator;

    public AssetRepository(Repository<T> repository, BeanValidator validator) {
        this.repository = repository;
        this.validator = validator;
    }

    protected Path resolveComponentPath(String componentId) {
        return this.repository.resolvePathFolder(componentId);
    }

    protected Path resolveAssetPath(String componentId, Asset asset) {
        this.validator.validate((Object)asset);
        return this.resolveComponentPath(componentId).resolve(ASSETS).resolve(asset.getType().getPrefix()).resolve(asset.getName());
    }

    protected Path resolveAssetPath(Asset asset) {
        return this.resolveAssetPath(asset.getComponentId(), asset);
    }

    protected Path resolveExistingAssetPath(Asset asset) {
        return this.resolveExistingAssetPath(asset.getComponentId(), asset);
    }

    protected Path resolveExistingAssetPath(String componentId, Asset asset) {
        Path path = this.resolveAssetPath(componentId, asset);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NotFoundException(String.format("Error when searching asset %s for %s [%s]: asset not found in path '%s'", asset.getName(), this.repository.getComponentName(), componentId, path));
        }
        return path;
    }

    public void save(Asset asset, byte[] content) throws IOException {
        Objects.requireNonNull(asset.getComponentId(), COMPONENT_ID_REQUIRED);
        Path parent = this.resolveComponentPath(asset.getComponentId());
        if (!Files.exists(parent.resolve(ASSETS).resolve(asset.getType().getPrefix()), new LinkOption[0])) {
            Files.createDirectories(parent.resolve(ASSETS).resolve(asset.getType().getPrefix()), new FileAttribute[0]);
        }
        Files.write(this.resolveAssetPath(asset), content, new OpenOption[0]);
    }

    public void save(String componentId, Asset asset, byte[] content) throws IOException {
        Path assetDirectory = this.resolveAssetDirectory(componentId, asset);
        if (!Files.exists(assetDirectory, new LinkOption[0])) {
            Files.createDirectories(assetDirectory, new FileAttribute[0]);
        }
        Files.write(assetDirectory.resolve(asset.getName()), content, new OpenOption[0]);
    }

    private Path resolveAssetDirectory(String componentId, Asset asset) {
        return this.repository.resolvePathFolder(componentId).resolve(ASSETS).resolve(asset.getType().getPrefix());
    }

    public void delete(Asset asset) throws IOException {
        Objects.requireNonNull(asset.getComponentId(), COMPONENT_ID_REQUIRED);
        Files.delete(this.resolveExistingAssetPath(asset));
    }

    public byte[] readAllBytes(Asset asset) throws IOException {
        Objects.requireNonNull(asset.getComponentId(), COMPONENT_ID_REQUIRED);
        return Files.readAllBytes(this.resolveExistingAssetPath(asset));
    }

    public byte[] readAllBytes(String componentId, Asset asset) throws IOException {
        Objects.requireNonNull(componentId, COMPONENT_ID_REQUIRED);
        return Files.readAllBytes(this.resolveExistingAssetPath(componentId, asset));
    }

    public Path findAssetPath(String componentId, String filename, AssetType assetType) {
        Objects.requireNonNull(filename, "Filename is required");
        Objects.requireNonNull(assetType, String.format("Asset type is required (filename: %s)", filename));
        T component = this.repository.get(componentId);
        Asset existingAsset = ((Assetable)component).getAssets().stream().filter(asset -> filename.equals(asset.getName()) && assetType.equals((Object)asset.getType())).findFirst().orElseThrow(() -> new NoSuchElementException("Asset not found"));
        existingAsset.setComponentId(componentId);
        if (existingAsset.isExternal()) {
            throw new NotAllowedException("We can't load an external asset. Use the link " + existingAsset.getName());
        }
        return this.resolveExistingAssetPath(existingAsset);
    }

    public List<Asset> findAssetInPath(T component, AssetType type, Path directory) throws IOException {
        ArrayList<Asset> objects = new ArrayList<Asset>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                objects.add(new Asset().setName(path.getFileName().toString()).setType(type).setScope(AssetScope.forComponent((Assetable)((Assetable)component))).setComponentId(component.getId()).setId(UUID.randomUUID().toString()));
            }
        }
        return objects;
    }

    public List<Asset> findAssetInPathWhithoutComponentId(T component, AssetType type, Path directory) throws IOException {
        ArrayList<Asset> objects = new ArrayList<Asset>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            String componentId = component instanceof Widget ? component.getId() : null;
            for (Path path : directoryStream) {
                objects.add(new Asset().setName(path.getFileName().toString()).setType(type).setScope(AssetScope.forComponent((Assetable)((Assetable)component))).setComponentId(componentId).setId(UUID.randomUUID().toString()));
            }
        }
        return objects;
    }

    public void refreshAssets(T component) {
        Set assets = Arrays.stream(AssetType.values()).map(type -> {
            try {
                Path assetTypePath = this.repository.resolvePath(component.getId()).resolve(Paths.get(ASSETS, type.getPrefix()));
                if (Files.exists(assetTypePath, new LinkOption[0])) {
                    return this.findAssetInPathWhithoutComponentId(component, (AssetType)type, assetTypePath);
                }
            }
            catch (IOException e) {
                throw new RepositoryException(String.format("Failed to initialized assets for %s %s", this.repository.getComponentName(), component.getId()), e);
            }
            return Collections.emptyList();
        }).flatMap(Collection::stream).collect(Collectors.toSet());
        ((Assetable)component).addAssets(assets);
        this.repository.updateLastUpdateAndSave(component);
    }
}

