/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.designer.common.livebuild.PathListener;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.model.Identifiable;

public interface Repository<T extends Identifiable> {
    public T get(String var1) throws NotFoundException, RepositoryException;

    public T getByUUID(String var1) throws NotFoundException, RepositoryException;

    public T get(Path var1);

    public List<T> getAll() throws RepositoryException;

    public T updateLastUpdateAndSave(T var1) throws RepositoryException;

    public T save(T var1) throws RepositoryException;

    public void saveAll(List<T> var1) throws RepositoryException;

    public void delete(String var1) throws NotFoundException, RepositoryException;

    public Path resolvePath(String var1);

    public List<T> findByObjectId(String var1) throws RepositoryException;

    public Map<String, List<T>> findByObjectIds(List<String> var1) throws RepositoryException;

    public String getComponentName();

    public Path resolvePathFolder(String var1);

    public boolean exists(String var1);

    public void walk(FileVisitor<? super Path> var1) throws IOException;

    public void watch(PathListener var1) throws IOException;

    public T markAsFavorite(String var1);

    public T unmarkAsFavorite(String var1);

    public String getNextAvailableId(String var1) throws IOException;

    public T load(Path var1);

    public List<T> loadAll(Path var1) throws IOException;

    public List<T> loadAll(Path var1, DirectoryStream.Filter<Path> var2) throws IOException;
}

