/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.common.repository;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.common.migration.Version;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.model.HasUUID;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetFileBasedPersister
extends JsonFileBasedPersister<Widget> {
    protected static final Logger logger = LoggerFactory.getLogger(WidgetFileBasedPersister.class);

    public WidgetFileBasedPersister(JsonHandler jsonHandler, BeanValidator validator, String version, String modelVersion) {
        super(jsonHandler, validator, version, modelVersion);
    }

    @Override
    public void save(Path directory, Widget content) throws IOException {
        String versionToSet = this.version;
        if (versionToSet != null) {
            String[] currentVersion = versionToSet.split("_");
            versionToSet = currentVersion[0];
        }
        content.setDesignerVersionIfEmpty(versionToSet);
        String artifactVersion = content.getArtifactVersion();
        if (artifactVersion == null || Version.isSupportingModelVersion(artifactVersion)) {
            content.setModelVersionIfEmpty(this.modelVersion);
        }
        this.validator.validate((Object)content);
        String templateFileName = content.getId() + ".tpl.html";
        Path templatePath = this.getFilePath(directory, templateFileName);
        String templateValue = content.getTemplate();
        String controllerFileName = content.getId() + ".ctrl.js";
        Path controllerPath = this.getFilePath(directory, controllerFileName);
        String controllerValue = content.getController();
        try {
            if (templateValue != null && !templateValue.startsWith("@")) {
                Files.write(templatePath, templateValue.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                content.setTemplate("@" + templateFileName);
            }
            if (controllerValue != null && !controllerValue.startsWith("@")) {
                Files.write(controllerPath, controllerValue.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                content.setController("@" + controllerFileName);
            }
            Files.write(this.jsonFile(directory, content.getId()), this.jsonHandler.toPrettyJson((Object)content, JsonViewPersistence.class), new OpenOption[0]);
            content.setTemplate(templateValue);
            content.setController(controllerValue);
            Path metadataPath = this.updateMetadata(directory, content);
            if (content instanceof HasUUID && !StringUtils.isEmpty((CharSequence)((HasUUID)content).getUUID())) {
                this.saveInIndex(metadataPath, content);
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public Path getFilePath(Path directory, String fileName) {
        return directory.resolve(fileName);
    }
}

