/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.page;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.ElementContainer;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonViewLight;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.data.Data;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.exception.NotFoundException;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.WebResource;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public abstract class AbstractPage
extends DesignerArtifact
implements Previewable,
Identifiable,
ElementContainer,
Assetable {
    private final Map<String, Data> data = null;
    private String id;
    @NotBlank(message="Page name should not be blank")
    @Pattern(regexp="[a-zA-Z0-9]*$", message="Page name should contains only alphanumeric characters with no space")
    private @NotBlank(message="Page name should not be blank") @Pattern(regexp="[a-zA-Z0-9]*$", message="Page name should contains only alphanumeric characters with no space") String name;
    private Instant lastUpdate;
    private List<List<Element>> rows = new ArrayList<List<Element>>();
    private Set<Asset> assets = new HashSet<Asset>();
    private Set<String> inactiveAssets = new HashSet<String>();
    private Map<String, Variable> variables = new HashMap<String, Variable>();
    private boolean hasValidationError = false;
    private Set<WebResource> automaticWebResources = new HashSet<WebResource>();

    @Override
    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Instant lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    @JsonView(value={JsonViewPersistence.class})
    public List<List<Element>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<Element>> rows) {
        this.rows = rows;
    }

    @Override
    @JsonView(value={JsonViewPersistence.class})
    public Set<Asset> getAssets() {
        return this.assets;
    }

    @Override
    public void setAssets(Set<Asset> assets) {
        this.assets = assets;
    }

    @Override
    public void addAsset(Asset asset) {
        if (this.assets == null) {
            this.assets = new HashSet<Asset>();
        }
        this.assets.add(asset);
    }

    @Override
    public void addAssets(Set<Asset> assets) {
        if (this.assets == null) {
            this.assets = new HashSet<Asset>();
        }
        this.assets.addAll(assets);
    }

    @Override
    @JsonView(value={JsonViewPersistence.class})
    public Set<String> getInactiveAssets() {
        return this.inactiveAssets;
    }

    public void setInactiveAssets(Set<String> inactiveAssets) {
        this.inactiveAssets = inactiveAssets;
    }

    public boolean hasAsset(AssetType type, String name) {
        return this.assets.stream().anyMatch(asset -> AssetType.CSS.equals((Object)type) && asset.getName().equals(name));
    }

    public Set<WebResource> getAutomaticWebResources() {
        return this.automaticWebResources;
    }

    @JsonIgnore
    public void setAutomaticWebResources(Set<WebResource> automaticWebResources) {
        this.automaticWebResources = automaticWebResources;
    }

    @Deprecated
    @JsonView(value={JsonViewPersistence.class})
    public Map<String, Data> getData() {
        return null;
    }

    @Deprecated
    public void setData(Map<String, Data> data) {
        if (data != null) {
            for (Map.Entry<String, Data> dataEntry : data.entrySet()) {
                this.variables.put(dataEntry.getKey(), this.convertDataToVariable(dataEntry.getValue()));
            }
        }
    }

    private Variable convertDataToVariable(Data data) {
        String variableValue = Objects.toString(data.getValue(), null);
        Variable variable = new Variable(data.getType(), variableValue);
        variable.setExposed(data.isExposed());
        return variable;
    }

    @Deprecated
    public void addData(String name, Data value) {
        this.variables.put(name, this.convertDataToVariable(value));
    }

    @Override
    @JsonView(value={JsonViewPersistence.class})
    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Variable> variables) {
        this.variables = variables;
    }

    @Override
    public void addVariable(String name, Variable value) {
        this.variables.put(name, value);
    }

    @Override
    public void removeVariable(String variableName) throws NotFoundException {
        if (!this.variables.containsKey(variableName)) {
            throw new NotFoundException("Variable [" + variableName + "] doesn't exists for page [" + this.id + "]");
        }
        this.variables.remove(variableName);
    }

    public <T> T accept(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractPage) {
            AbstractPage other = (AbstractPage)obj;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append(this.rows, other.rows).append(this.data, other.data).append((Object)this.getModelVersion(), (Object)other.getModelVersion()).append((Object)this.getDesignerVersion(), (Object)other.getDesignerVersion()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append(this.rows).append(this.data).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("rows", this.rows).append("data", this.data).append("modelVersion", (Object)this.getModelVersion()).append("designerVersion", (Object)this.getDesignerVersion()).toString();
    }

    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public boolean getHasValidationError() {
        return this.hasValidationError;
    }

    public void setHasValidationError(boolean hasValidationError) {
        this.hasValidationError = hasValidationError;
    }
}

