/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.page;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.bonitasoft.web.designer.model.JsonViewLight;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
public abstract class Element {
    private Map<String, Integer> dimension = new TreeMap<String, Integer>();
    private Map<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();
    private String reference;
    private boolean hasValidationError = false;

    protected Element() {
        this.dimension.put("xs", 12);
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getReference() {
        if (this.reference == null) {
            this.reference = UUID.randomUUID().toString();
        }
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @JsonView(value={JsonViewPersistence.class})
    public Map<String, Integer> getDimension() {
        return this.dimension;
    }

    public void setDimension(Map<String, Integer> dimension) {
        this.dimension = dimension;
    }

    @JsonView(value={JsonViewPersistence.class})
    public Map<String, PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Map<String, PropertyValue> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public abstract <T> T accept(ElementVisitor<T> var1);

    @JsonIgnore
    public String getDimensionAsCssClasses() {
        StringBuilder classes = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.dimension.entrySet()) {
            classes.append(this.stringifyColumn(entry.getKey(), entry.getValue())).append(" ");
        }
        return classes.toString().trim();
    }

    private String stringifyColumn(String prefix, Integer size) {
        return size == null ? "" : String.format("col-%s-%d ", prefix, size);
    }

    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public boolean getHasValidationError() {
        return this.hasValidationError;
    }

    public void setHasValidationError(boolean hasValidationError) {
        this.hasValidationError = hasValidationError;
    }
}

