/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.asset;

import com.fasterxml.jackson.annotation.JsonView;
import java.util.Comparator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.asset.AssetType;

public class Asset {
    private String id;
    @NotBlank(message="Asset name should not be blank")
    private @NotBlank(message="Asset name should not be blank") String name;
    @NotNull(message="Asset type may not be null")
    private @NotNull(message="Asset type may not be null") AssetType type;
    private String componentId;
    private String scope;
    private int order;
    private boolean active = true;
    private boolean external = false;

    public static Comparator<Asset> getComparatorByOrder() {
        return Comparator.comparingInt(Asset::getOrder);
    }

    public static Comparator<Asset> getComparatorByComponentId() {
        return (asset1, asset2) -> ObjectUtils.compare((Comparable)((Object)asset1.getComponentId()), (Comparable)((Object)asset2.getComponentId()), (boolean)true);
    }

    @JsonView(value={JsonViewAsset.class, JsonViewPersistence.class})
    public String getId() {
        return this.id;
    }

    public Asset setId(String id) {
        this.id = id;
        return this;
    }

    @JsonView(value={JsonViewAsset.class, JsonViewPersistence.class})
    public boolean isExternal() {
        return this.external;
    }

    public Asset setExternal(boolean external) {
        this.external = external;
        return this;
    }

    @JsonView(value={JsonViewPersistence.class, JsonViewAsset.class})
    public String getName() {
        return this.name;
    }

    public Asset setName(String name) {
        this.name = name;
        return this;
    }

    @JsonView(value={JsonViewPersistence.class, JsonViewAsset.class})
    public AssetType getType() {
        return this.type;
    }

    public Asset setType(AssetType type) {
        this.type = type;
        return this;
    }

    @JsonView(value={JsonViewAsset.class})
    public String getComponentId() {
        return this.componentId;
    }

    public Asset setComponentId(String componentId) {
        this.componentId = componentId;
        return this;
    }

    @JsonView(value={JsonViewAsset.class})
    public String getScope() {
        return this.scope;
    }

    public Asset setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @JsonView(value={JsonViewPersistence.class, JsonViewAsset.class})
    public int getOrder() {
        return this.order;
    }

    public Asset setOrder(int order) {
        this.order = order;
        return this;
    }

    @JsonView(value={JsonViewAsset.class})
    public boolean isActive() {
        return this.active;
    }

    public Asset setActive(boolean inactive) {
        this.active = inactive;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Asset) {
            Asset other = (Asset)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.type, (Object)other.type).append((Object)this.componentId, (Object)other.componentId).isEquals();
        }
        return false;
    }

    public boolean equalsWithoutComponentId(Object obj) {
        if (obj instanceof Asset) {
            Asset other = (Asset)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.type, (Object)other.type).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).append("type", (Object)this.type).append("componentId", (Object)this.componentId).append("active", this.active).toString();
    }

    public static interface JsonViewAsset {
    }
}

