/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.page;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bonitasoft.web.designer.model.ElementContainer;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

@JsonTypeName(value="container")
public class Container
extends Component
implements ElementContainer {
    private List<List<Element>> rows = new ArrayList<List<Element>>();

    @Override
    public String getId() {
        return "pbContainer";
    }

    @Override
    @JsonView(value={JsonViewPersistence.class})
    public List<List<Element>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<Element>> rows) {
        this.rows = rows;
    }

    @Override
    public <T> T accept(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @JsonIgnore
    public boolean isRepeated() {
        return this.getPropertyValues().containsKey("repeatedCollection") && !StringUtils.isEmpty((CharSequence)((String)this.getPropertyValues().get("repeatedCollection").getValue()));
    }

    public Container addNewRow(Element element) {
        this.getRows().add(Collections.singletonList(element));
        return this;
    }

    public Container addNewRow(List<Element> elements) {
        this.getRows().add(elements);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Container) {
            Container other = (Container)obj;
            return new EqualsBuilder().append(this.rows, other.rows).append(this.getDimension(), other.getDimension()).append(this.getPropertyValues(), other.getPropertyValues()).isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.rows).append(this.getDimension()).append(this.getPropertyValues()).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("rows", this.rows).append("dimension", this.getDimension()).append("propertyValues", this.getPropertyValues()).toString();
    }
}

