/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import java.io.IOException;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.widget.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonDeserializationProblemHandler
extends DeserializationProblemHandler {
    private static final Logger logger = LoggerFactory.getLogger(JacksonDeserializationProblemHandler.class);

    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
        if (beanOrClass instanceof Asset && "inactive".equals(propertyName)) {
            logger.info("[MIGRATION] inactive asset is deprecated since 1.0.1");
            return true;
        }
        if (beanOrClass instanceof Property && "bidirectional".equals(propertyName)) {
            logger.info("[MIGRATION] bidirectional property is deprecated since 1.0.2");
            return true;
        }
        return super.handleUnknownProperty(ctxt, jp, deserializer, beanOrClass, propertyName);
    }
}

