/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.LocalizationPrettyPrinter;
import org.bonitasoft.web.designer.model.exception.MalformedJsonException;

public class JacksonJsonHandler
implements JsonHandler {
    private final ObjectMapper objectMapper;

    public JacksonJsonHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T fromJson(byte[] bytes, Class<T> type) throws IOException {
        return (T)this.objectMapper.readValue(bytes, type);
    }

    @Override
    public <T> T fromJson(Path jsonFile, Class<T> type, Class<?> view) throws IOException {
        return this.fromJson(Files.readAllBytes(jsonFile), type, view);
    }

    @Override
    public <T> T fromJson(byte[] bytes, Class<T> type, Class<?> view) throws IOException {
        return (T)this.objectMapper.reader().withView(view).forType(type).readValue(bytes);
    }

    @Override
    public Map<String, String> fromJsonToMap(byte[] bytes) throws IOException {
        TypeFactory factory = TypeFactory.defaultInstance();
        MapType mapType = factory.constructMapType(HashMap.class, String.class, String.class);
        return (Map)this.objectMapper.readValue(bytes, (JavaType)mapType);
    }

    @Override
    public LinkedHashMap<String, Object> fromJsonToComplexMap(byte[] bytes) throws IOException {
        TypeFactory factory = TypeFactory.defaultInstance();
        MapType mapType = factory.constructMapType(LinkedHashMap.class, String.class, Object.class);
        return (LinkedHashMap)this.objectMapper.readValue(bytes, (JavaType)mapType);
    }

    @Override
    public byte[] toJson(Object object) throws IOException {
        return this.objectMapper.writeValueAsString(object).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toJson(Object object, Class<?> serializationView) throws IOException {
        return this.objectMapper.writerWithView(serializationView).writeValueAsString(object).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String toJsonString(Object object) throws IOException {
        return new String(this.toJson(object), StandardCharsets.UTF_8);
    }

    @Override
    public String toJsonString(Object object, Class<?> serializationView) throws IOException {
        return new String(this.toJson(object, serializationView), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toJson(Map<String, String> map) throws IOException {
        return this.objectMapper.writeValueAsString(map).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toPrettyJsonFromComplexMap(LinkedHashMap<String, Object> map) throws IOException {
        return this.objectMapper.writer().with((PrettyPrinter)new LocalizationPrettyPrinter(": ").withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE)).writeValueAsString(map).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toPrettyJson(Object object, Class<?> serializationView) throws IOException {
        return this.objectMapper.writerWithView(serializationView).with((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE)).writeValueAsString(object).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String prettyPrint(Object object) throws IOException {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        try {
            String string = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            return string;
        }
        finally {
            this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    @Override
    public String prettyPrint(String json) throws IOException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.fromJson(json.getBytes(StandardCharsets.UTF_8), Object.class));
    }

    @Override
    public void checkValidJson(byte[] bytes) throws IOException {
        try (JsonParser parser = this.objectMapper.getFactory().createParser(bytes);){
            while (parser.nextToken() != null) {
            }
        }
        catch (JsonProcessingException e) {
            throw new MalformedJsonException(e);
        }
    }

    @Override
    public <T> T assign(T target, byte[] source) throws IOException {
        return (T)this.objectMapper.readerForUpdating(target).readValue(source);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

