/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.fragment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.WordUtils;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonViewLight;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.FragmentElement;

@JsonPropertyOrder(value={"id", "name", "type", "modelVersion", "previousArtifactVersion", "lastUpdate", "description", "rows", "variables", "assets", "inactiveAssets", "webResources"})
public class Fragment
extends AbstractPage {
    private Map<String, List<Identifiable>> usedBy;

    @JsonView(value={JsonViewLight.class})
    public Map<String, List<Identifiable>> getUsedBy() {
        return this.usedBy;
    }

    public void addUsedBy(String componentName, List<Identifiable> components) {
        if (components != null && !components.isEmpty()) {
            if (this.usedBy == null) {
                this.usedBy = new HashMap<String, List<Identifiable>>();
            }
            this.usedBy.put(componentName, components);
        }
    }

    @Override
    public String getType() {
        return "fragment";
    }

    @JsonIgnore
    public boolean isUsed() {
        return this.getUsedBy() != null && !this.getUsedBy().isEmpty();
    }

    @JsonIgnore
    public String getDirectiveName() {
        return "pbFragment" + WordUtils.capitalize((String)this.getName());
    }

    @JsonIgnore
    public Map<String, Variable> getExposedVariables() {
        return this.getVariables().entrySet().stream().filter(entry -> ((Variable)entry.getValue()).isExposed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Container toContainer(FragmentElement fragmentElement) {
        Container container = new Container();
        container.setRows(this.getRows());
        container.setReference(fragmentElement.getReference());
        container.setPropertyValues(fragmentElement.getPropertyValues());
        return container;
    }
}

