/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonView;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonViewLight;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.exception.NotFoundException;
import org.bonitasoft.web.designer.model.widget.Property;

@JsonPropertyOrder(value={"id", "name", "type", "custom", "modelVersion", "previousArtifactVersion", "lastUpdate", "description", "template", "controller", "properties", "assets", "requiredModules", "webResources"})
public class Widget
extends DesignerArtifact
implements Identifiable,
Assetable {
    private static final Pattern PATTERN_DATE_VALIDATION = Pattern.compile("[a-zA-Z0-9]*$");
    @Valid
    private final List<Property> properties = new ArrayList<Property>();
    @NotBlank
    private String id;
    @NotBlank(message="Widget name should not be blank")
    private @NotBlank(message="Widget name should not be blank") String name;
    private Instant lastUpdate;
    private String template;
    private String icon;
    private String controller;
    private String description;
    private boolean custom;
    private Integer order;
    private Map<String, List<Identifiable>> usedBy;
    private Set<Asset> assets = new HashSet<Asset>();
    private Set<String> requiredModules = new HashSet<String>();
    private Set<String> authRules;
    private String type = "widget";
    private boolean hasHelp = false;

    public static String spinalCase(String widgetId) {
        char firstLetter = Character.toLowerCase(widgetId.charAt(0));
        return firstLetter + widgetId.substring(1).replaceAll("([A-Z])", "-$1").toLowerCase(Locale.ENGLISH);
    }

    @AssertTrue(message="Widget name should contains only alphanumeric characters with no space")
    private @AssertTrue(message="Widget name should contains only alphanumeric characters with no space") boolean isValidName() {
        if (!this.isCustom()) {
            return true;
        }
        return PATTERN_DATE_VALIDATION.matcher(this.name).matches();
    }

    @Override
    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Instant lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getController() {
        return this.controller;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonView(value={JsonViewLight.class, JsonViewPersistence.class})
    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    @JsonView(value={JsonViewPersistence.class})
    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    @JsonView(value={JsonViewPersistence.class})
    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void replaceProperty(Property oldProperty, Property newProperty) {
        Collections.replaceAll(this.properties, oldProperty, newProperty);
    }

    @Override
    @JsonView(value={JsonViewPersistence.class})
    public Set<Asset> getAssets() {
        return this.assets;
    }

    @Override
    public void setAssets(Set<Asset> assets) {
        this.assets = assets;
    }

    @Override
    public void addAsset(Asset asset) {
        if (this.assets == null) {
            this.assets = new HashSet<Asset>();
        }
        this.assets.add(asset);
    }

    @Override
    public void addAssets(Set<Asset> assets) {
        if (this.assets == null) {
            this.assets = new HashSet<Asset>();
        }
        this.assets.addAll(assets);
    }

    public void deleteProperty(Property property) {
        this.properties.remove(property);
    }

    public Property getProperty(String propertyName) {
        return this.properties.stream().filter(property -> propertyName.equals(property.getName())).findFirst().orElse(null);
    }

    @JsonView(value={JsonViewLight.class})
    public Map<String, List<Identifiable>> getUsedBy() {
        return this.usedBy;
    }

    public void addUsedBy(String componantName, List<Identifiable> components) {
        if (components != null && !components.isEmpty()) {
            if (this.usedBy == null) {
                this.usedBy = new HashMap<String, List<Identifiable>>();
            }
            this.usedBy.put(componantName, components);
        }
    }

    @JsonIgnore
    public boolean isUsed() {
        return this.getUsedBy() != null && !this.getUsedBy().isEmpty();
    }

    @JsonIgnore
    public boolean isCompatible() {
        return !this.isCustom() || this.getStatus() == null || this.getStatus().isCompatible();
    }

    @JsonView(value={JsonViewPersistence.class})
    public Set<String> getRequiredModules() {
        return this.requiredModules;
    }

    public void setRequiredModules(Set<String> requiredModules) {
        this.requiredModules = requiredModules;
    }

    @JsonView(value={JsonViewPersistence.class})
    public Set<String> getAuthRules() {
        return this.authRules;
    }

    public void setAuthRules(Set<String> authRules) {
        this.authRules = authRules;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null) {
            this.type = type;
        }
    }

    @JsonView(value={JsonViewPersistence.class})
    public boolean hasHelp() {
        return this.hasHelp;
    }

    public void setHasHelp(boolean hasHelp) {
        this.hasHelp = hasHelp;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Widget) {
            Widget other = (Widget)obj;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.name, (Object)other.name).append((Object)this.template, (Object)other.template).append((Object)this.controller, (Object)other.controller).append(this.custom, other.custom).append(this.properties, other.properties).append(this.hasHelp, other.hasHelp).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.name).append((Object)this.template).append((Object)this.controller).append(this.custom).append(this.properties).append(this.hasHelp).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).append("template", (Object)this.template).append("controller", (Object)this.controller).append("custom", this.custom).append("properties", this.properties).append("hasHelp", this.hasHelp).toString();
    }

    public void prepareWidgetToDeserialize(Path directory) throws IOException {
        this.loadControllerFromFileContent(directory);
        this.loadTemplateFromFileContent(directory);
    }

    public void prepareWidgetToSerialize() {
        if (this.getTemplate() != null && !this.getTemplate().startsWith("@")) {
            String templateFileName = "@" + this.getId() + ".tpl.html";
            this.setTemplate(templateFileName);
        }
        if (this.getController() != null && !this.getController().startsWith("@")) {
            String controllerFileName = "@" + this.getId() + ".ctrl.js";
            this.setController(controllerFileName);
        }
    }

    private void loadControllerFromFileContent(Path directory) throws IOException {
        if (this.getController() != null && this.getController().startsWith("@")) {
            String controllerFileName = this.getController().substring(1);
            Path controllerFile = directory.resolve(String.format("%s", controllerFileName));
            if (!Files.exists(controllerFile, new LinkOption[0])) {
                throw new NotFoundException(String.format("Controller not found for [%s]", controllerFile.getFileName()));
            }
            this.setController(new String(Files.readAllBytes(controllerFile), StandardCharsets.UTF_8));
        }
    }

    private void loadTemplateFromFileContent(Path directory) throws IOException {
        if (this.getTemplate() != null && this.getTemplate().startsWith("@")) {
            String templateFileName = this.getTemplate().substring(1);
            Path templateFile = directory.resolve(String.format("%s", templateFileName));
            if (!Files.exists(templateFile, new LinkOption[0])) {
                throw new NotFoundException(String.format("Template not found for [%s]", templateFile.getFileName()));
            }
            this.setTemplate(new String(Files.readAllBytes(templateFile), StandardCharsets.UTF_8));
        }
    }
}

