/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.page;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bonitasoft.web.designer.model.JsonViewPersistence;

public class WebResource {
    private String method;
    private String value;
    private Set<String> scopes = new HashSet<String>();
    private boolean isAutomaticDetection = false;

    @JsonCreator
    public WebResource(@JsonProperty(value="method") String method, @JsonProperty(value="value") String value) {
        this.method = method;
        this.value = value;
    }

    public WebResource(String method, String value, String scope) {
        this.method = method.toLowerCase();
        this.value = value;
        this.scopes.add(scope);
        this.isAutomaticDetection = true;
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void addToScopes(String value) {
        this.scopes.add(value);
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String toDefinition() {
        return this.method.toUpperCase().concat("|").concat(this.value);
    }

    @JsonView
    public boolean isAutomatic() {
        return this.isAutomaticDetection;
    }

    @JsonIgnore
    public void setAutomatic(boolean isAutomaticDetection) {
        this.isAutomaticDetection = isAutomaticDetection;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("method", (Object)this.method).append("value", (Object)this.value).append("isAutomaticDetection", this.isAutomaticDetection).append("scope", (Object)this.scopes.toString()).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebResource)) {
            return false;
        }
        WebResource other = (WebResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutomaticDetection != other.isAutomaticDetection) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Set<String> this$scopes = this.getScopes();
        Set<String> other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutomaticDetection ? 79 : 97);
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Set<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        return result;
    }
}

