/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonViewLight;
import org.bonitasoft.web.designer.model.JsonViewMetadata;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.page.WebResource;

@JsonIgnoreProperties(value={"designerVersion"}, allowSetters=true, ignoreUnknown=true)
public abstract class DesignerArtifact
implements Identifiable {
    private String modelVersion;
    @JsonView(value={JsonViewPersistence.class})
    private String designerVersion;
    private String previousDesignerVersion;
    private String previousArtifactVersion;
    private boolean favorite = false;
    private ArtifactStatusReport status;
    private Set<WebResource> webResources = new HashSet<WebResource>();

    @Override
    @JsonView(value={JsonViewPersistence.class})
    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(String version) {
        this.modelVersion = version;
    }

    @Override
    public void setModelVersionIfEmpty(String version) {
        if (StringUtils.isBlank((CharSequence)this.modelVersion) || this.modelVersion.split("_").length > 1) {
            this.setModelVersion(version);
        }
    }

    @Override
    public String getDesignerVersion() {
        return this.designerVersion;
    }

    public void setDesignerVersion(String version) {
        this.designerVersion = version;
    }

    @Override
    public void setDesignerVersionIfEmpty(String version) {
        if (StringUtils.isBlank((CharSequence)this.designerVersion) || this.designerVersion.split("_").length > 1) {
            this.setDesignerVersion(version);
        }
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getPreviousArtifactVersion() {
        return this.previousArtifactVersion;
    }

    public void setPreviousArtifactVersion(String version) {
        this.previousArtifactVersion = version;
    }

    @JsonView(value={JsonViewPersistence.class})
    public String getPreviousDesignerVersion() {
        return this.previousDesignerVersion;
    }

    public void setPreviousDesignerVersion(String version) {
        this.previousArtifactVersion = version;
    }

    @Override
    @JsonIgnore
    public String getArtifactVersion() {
        if (this.getModelVersion() != null) {
            return this.getModelVersion();
        }
        return this.getDesignerVersion();
    }

    @Override
    @JsonView(value={JsonViewMetadata.class, JsonViewLight.class})
    public boolean isFavorite() {
        return this.favorite;
    }

    @Override
    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    @Override
    @JsonView(value={JsonViewPersistence.class, JsonViewLight.class})
    public abstract String getType();

    @JsonView(value={JsonViewLight.class})
    public ArtifactStatusReport getStatus() {
        return this.status;
    }

    @JsonIgnore
    public void setStatus(ArtifactStatusReport status) {
        this.status = status;
    }

    @JsonView(value={JsonViewPersistence.class})
    public Set<WebResource> getWebResources() {
        return this.webResources;
    }

    public void setWebResources(Set<WebResource> webResources) {
        this.webResources = webResources;
    }
}

