/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.VariableAdvancedOptions;

@JsonFilter(value="valueAsArray")
public class Variable {
    private DataType type;
    private String displayValue;
    private boolean exposed;
    private VariableAdvancedOptions advancedOptions;

    @JsonCreator
    public Variable(@JsonProperty(value="type") DataType type, @JsonProperty(value="value") List<String> value, @JsonProperty(value="advancedOptions") VariableAdvancedOptions advancedOptions) {
        this.type = type;
        this.displayValue = Variable.getValueAsString(value);
        this.advancedOptions = advancedOptions;
    }

    public Variable(DataType type, String displayValue) {
        this.type = type;
        this.displayValue = displayValue;
    }

    @JsonView(value={JsonViewPersistence.class})
    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    @JsonView(value={JsonViewPersistence.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getValue() {
        return Variable.getValueAsArray(this.displayValue);
    }

    public void setValue(List<String> value) {
        this.displayValue = Variable.getValueAsString(value);
    }

    @JsonView(value={JsonViewPersistence.class})
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public VariableAdvancedOptions getAdvancedOptions() {
        return this.advancedOptions;
    }

    public void setAdvancedOptions(VariableAdvancedOptions options) {
        this.advancedOptions = options;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    private static List<String> getValueAsArray(String value) {
        return value != null ? Arrays.asList(value.split("\\n")) : Collections.emptyList();
    }

    private static String getValueAsString(List<String> value) {
        return value != null ? String.join((CharSequence)"\n", value) : null;
    }

    @JsonView(value={JsonViewPersistence.class})
    public boolean isExposed() {
        return this.exposed;
    }

    public void setExposed(boolean exposed) {
        this.exposed = exposed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variable) {
            Variable other = (Variable)obj;
            return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.displayValue, (Object)other.displayValue).append(this.exposed, other.exposed).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.type).append((Object)this.displayValue).append(this.exposed).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("type", (Object)this.type).append("displayValue", (Object)this.displayValue).append("exposed", this.exposed).toString();
    }
}

