/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.export.ExportStep;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.controller.export.ExportException;
import org.bonitasoft.web.designer.controller.export.WidgetExporter;
import org.bonitasoft.web.designer.controller.utils.Unzipper;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.WidgetService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class WidgetExporterTest {
    @Mock
    private WidgetService widgetService;
    private final JsonHandler jsonHandler = new JsonHandlerFactory().create();
    private WidgetExporter exporter;
    private ByteArrayOutputStream artifactStream;
    @TempDir
    Path repositoryFolder;

    WidgetExporterTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.artifactStream = new ByteArrayOutputStream();
        this.exporter = new WidgetExporter(this.jsonHandler, this.widgetService, new ExportStep[]{(ExportStep)Mockito.mock(ExportStep.class)});
    }

    private Widget create(Widget widget) throws IOException {
        if (widget.getId() == null) {
            widget.setId("default-id");
        }
        Mockito.when((Object)this.widgetService.get(widget.getId())).thenReturn((Object)widget);
        Files.write(this.repositoryFolder.resolve(String.format("%s.json", widget.getId())), this.jsonHandler.toJson((Object)widget, JsonViewPersistence.class), new OpenOption[0]);
        return widget;
    }

    private Path unzip(ByteArrayOutputStream artifactZipStream) throws IOException {
        return new Unzipper().unzipInTempDir((InputStream)new ByteArrayInputStream(artifactZipStream.toByteArray()), "exportertest");
    }

    @Test
    void should_throw_exception_when_id_is_null() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.exporter.handleFileExport(null, (OutputStream)this.artifactStream));
    }

    @Test
    void should_throw_exception_when_id_is_blank() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.exporter.handleFileExport(" ", (OutputStream)this.artifactStream));
    }

    @Test
    void should_throw_exception_when_artefact_to_export_is_not_found() throws Exception {
        NotFoundException cause = new NotFoundException("Widget not found");
        Mockito.when((Object)this.widgetService.get("unknown-id")).thenThrow(new Throwable[]{cause});
        Throwable throwable = Assertions.catchThrowable(() -> this.exporter.handleFileExport("unknown-id", (OutputStream)this.artifactStream));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(ExportException.class)).hasCause((Throwable)cause);
    }

    @Test
    void should_export_template_and_controller_file_reference() throws Exception {
        Widget widget = this.create(WidgetBuilder.aWidget().withId("aWidget").custom().controller("function widgetCtrl(){}").template("<p>A widget label</p>").build());
        this.exporter.handleFileExport(widget.getId(), (OutputStream)this.artifactStream);
        Path unzipped = this.unzip(this.artifactStream);
        String res = "{\"id\":\"aWidget\",\"name\":\"aName\",\"type\":\"widget\",\"custom\":true,\"template\":\"@aWidget.tpl.html\",\"controller\":\"@aWidget.ctrl.js\",\"properties\":[],\"assets\":[],\"requiredModules\":[],\"webResources\":[],\"hasHelp\":false}";
        Assertions.assertThat((String)Files.readString(unzipped.resolve("resources/widget.json"))).isEqualTo(res);
    }

    @Test
    void should_export_a_widget_without_template_and_controller() throws Exception {
        Widget widget = this.create(WidgetBuilder.aWidget().withId("aWidget").custom().build());
        widget.setTemplate(null);
        this.exporter.handleFileExport(widget.getId(), (OutputStream)this.artifactStream);
        Path unzipped = this.unzip(this.artifactStream);
        String res = "{\"id\":\"aWidget\",\"name\":\"aName\",\"type\":\"widget\",\"custom\":true,\"properties\":[],\"assets\":[],\"requiredModules\":[],\"webResources\":[],\"hasHelp\":false}";
        Assertions.assertThat((String)Files.readString(unzipped.resolve("resources/widget.json"))).isEqualTo(res);
    }
}

