/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.common.repository.AssetRepository;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.StyleAssetMigrationStep;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.utils.FakePageRepository;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class StyleAssetMigrationStepTest {
    @Mock
    private AssetRepository<Page> assetRepository;
    private final PageRepository pageRepository = new FakePageRepository();
    private StyleAssetMigrationStep step;

    StyleAssetMigrationStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        AssetService pageAssetService = new AssetService((Repository)this.pageRepository, this.assetRepository, null);
        this.step = new StyleAssetMigrationStep(Path.of("src/test/resources", new String[0]), pageAssetService);
    }

    private Asset expectedAsset(String name) {
        return AssetBuilder.anAsset().withType(AssetType.CSS).withName(name).build();
    }

    private byte[] expectedAssetContent() throws IOException {
        return IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("templates/page/assets/css/style.css"));
    }

    @Test
    void should_add_new_style_asset_to_migrated_pages() throws Exception {
        Page page = PageBuilder.aPage().withDesignerVersion("1.4.7").build();
        this.step.migrate(page);
        Page migratedPage = (Page)this.pageRepository.get(page.getId());
        Assertions.assertThat((Collection)migratedPage.getAssets()).contains((Object[])new Asset[]{this.expectedAsset("style.css")});
        ((AssetRepository)Mockito.verify(this.assetRepository)).save(page.getId(), this.expectedAsset("style.css"), this.expectedAssetContent());
    }

    @Test
    void should_add_new_style_asset_with_different_name_while_already_existing() throws Exception {
        Page page = PageBuilder.aPage().withDesignerVersion("1.4.7").withAsset(new AssetBuilder[]{AssetBuilder.anAsset().withType(AssetType.CSS).withName("style.css")}).withAsset(new AssetBuilder[]{AssetBuilder.anAsset().withType(AssetType.CSS).withName("style1.css")}).build();
        this.step.migrate(page);
        Page migratedPage = (Page)this.pageRepository.get(page.getId());
        Assertions.assertThat((Collection)migratedPage.getAssets()).contains((Object[])new Asset[]{this.expectedAsset("style2.css")});
        ((AssetRepository)Mockito.verify(this.assetRepository)).save(page.getId(), this.expectedAsset("style2.css"), this.expectedAssetContent());
    }
}

