/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.StyleUpdateInputTypeMigrationStep;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class StyleUpdateInputTypeMigrationStepTest {
    @Mock
    private AssetService<Page> pageAssetService;
    @InjectMocks
    private StyleUpdateInputTypeMigrationStep step;

    StyleUpdateInputTypeMigrationStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.step = new StyleUpdateInputTypeMigrationStep(this.pageAssetService);
    }

    private Asset expectedAsset(String name) {
        return AssetBuilder.anAsset().withType(AssetType.CSS).withName(name).build();
    }

    @Test
    void should_migrate_style_asset_to_only_update_control_label_required_content_property() throws Exception {
        Asset style = AssetBuilder.anAsset().withType(AssetType.CSS).withName("style.css").build();
        String initContent = "/* Set a red border to invalid input fields in forms */\ninput[type='text'].ng-invalid.ng-dirty, input[type='email'].ng-invalid.ng-dirty,\ninput[type='number'].ng-invalid.ng-dirty, input[type='password'].ng-invalid.ng-dirty {\n  border-color: #C00;\n  border-width: 1px;\n}\n";
        Page page = PageBuilder.aPage().withDesignerVersion("1.15.12").withModelVersion("2.4").withAsset(new Asset[]{style}).build();
        Mockito.when((Object)this.pageAssetService.getAssetContent((Assetable)page, style)).thenReturn((Object)initContent);
        String finalContent = "/* Set a red border to invalid input fields in forms */\ninput[type='text'].ng-invalid.ng-dirty, input[type='email'].ng-invalid.ng-dirty,\ninput[type='number'].ng-invalid.ng-dirty, input[type='url'].ng-invalid.ng-dirty,\ninput[type='password'].ng-invalid.ng-dirty {\n  border-color: #C00;\n  border-width: 1px;\n}\n";
        this.step.migrate(page);
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, this.expectedAsset("style.css"), finalContent.getBytes());
    }

    @Test
    void should_migrate_style_asset_when_only_type_text_is_exist() throws Exception {
        Asset style = AssetBuilder.anAsset().withType(AssetType.CSS).withName("style.css").build();
        String initContent = "/* Set a red border to invalid input fields in forms */\ninput[type='text'].ng-invalid.ng-dirty {\n  border-color: #C00;\n  border-width: 1px;\n}\n";
        Page page = PageBuilder.aPage().withDesignerVersion("1.15.12").withModelVersion("2.4").withAsset(new Asset[]{style}).build();
        Mockito.when((Object)this.pageAssetService.getAssetContent((Assetable)page, style)).thenReturn((Object)initContent);
        String finalContent = "/* Set a red border to invalid input fields in forms */\ninput[type='url'].ng-invalid.ng-dirty,\ninput[type='text'].ng-invalid.ng-dirty {\n  border-color: #C00;\n  border-width: 1px;\n}\n";
        this.step.migrate(page);
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, this.expectedAsset("style.css"), finalContent.getBytes());
    }

    @Test
    void should_not_migrate_style_when_no_css_selector_exists() throws Exception {
        Asset style = AssetBuilder.anAsset().withType(AssetType.CSS).withName("style.css").build();
        String initContent = "/* Set a red border to invalid input fields in forms */\n";
        Page page = PageBuilder.aPage().withDesignerVersion("1.15.12").withModelVersion("2.4").withAsset(new Asset[]{style}).build();
        Mockito.when((Object)this.pageAssetService.getAssetContent((Assetable)page, style)).thenReturn((Object)initContent);
        String finalContent = "/* Set a red border to invalid input fields in forms */\n";
        this.step.migrate(page);
        ((AssetService)Mockito.verify(this.pageAssetService, (VerificationMode)Mockito.never())).save((Assetable)page, this.expectedAsset("style.css"), finalContent.getBytes());
    }
}

