/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.model.ParameterType;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.WebResource;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.visitor.WebResourcesVisitor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class WebResourcesVisitorTest {
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private WidgetRepository widgetRepository;
    @InjectMocks
    private WebResourcesVisitor webResourcesVisitor;
    private Component buttonGet;
    private Component btnSubmitTask;

    WebResourcesVisitorTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.lenient().when((Object)((Widget)this.widgetRepository.get((String)Mockito.any(String.class)))).thenReturn((Object)WidgetBuilder.aWidget().build());
        this.buttonGet = (Component)ComponentBuilder.aComponent().withWidgetId("buttonGet").withPropertyValue("action", "constant", (Object)"GET").withPropertyValue("url", "constant", (Object)"../API/identity/user").build();
        this.btnSubmitTask = (Component)ComponentBuilder.aComponent().withWidgetId("btnSubmitTask").withPropertyValue("action", "constant", (Object)"Submit task").build();
    }

    @Test
    void should_collect_webResources_when_visiting_a_component() throws Exception {
        Map webResourceMap = this.webResourcesVisitor.visit(this.buttonGet);
        Assertions.assertThat((Map)webResourceMap).containsOnly(new Map.Entry[]{Assertions.entry((Object)"GET|identity/user", (Object)new WebResource("GET", "identity/user", this.buttonGet.getId()))});
        webResourceMap = this.webResourcesVisitor.visit(this.btnSubmitTask);
        Assertions.assertThat((Map)webResourceMap).containsOnly(new Map.Entry[]{Assertions.entry((Object)"POST|bpm/userTask", (Object)new WebResource("POST", "bpm/userTask", this.btnSubmitTask.getId()))});
    }

    @Test
    void should_collect_webResources_from_a_container() throws Exception {
        Map webResourceMap = this.webResourcesVisitor.visit(ContainerBuilder.aContainer().with(new Element[]{this.buttonGet}).build());
        Assertions.assertThat((Map)webResourceMap).hasSize(1);
    }

    @Test
    void should_collect_webResource_from_a_tabs_container() throws Exception {
        Map webResourceMap = this.webResourcesVisitor.visit(TabsContainerBuilder.aTabsContainer().with(new TabContainerBuilder[]{TabContainerBuilder.aTabContainer().with((ElementBuilder)ContainerBuilder.aContainer().with(new Element[]{this.buttonGet}).with(Arrays.asList(this.buttonGet, this.btnSubmitTask)))}).build());
        Assertions.assertThat((Map)webResourceMap).hasSize(2);
    }

    @Test
    void should_collect_component_from_a_formcontainer() throws Exception {
        Map webResourceMap = this.webResourcesVisitor.visit(FormContainerBuilder.aFormContainer().with(ContainerBuilder.aContainer().with(new Element[]{this.buttonGet}).with(Arrays.asList(this.buttonGet, this.btnSubmitTask))).build());
        Assertions.assertThat((Map)webResourceMap).hasSize(2);
    }

    @Test
    void should_collect_component_from_a_previewable() throws Exception {
        Map webResourceMap = this.webResourcesVisitor.visit((Previewable)PageBuilder.aPage().with(new Element[]{this.btnSubmitTask}).withVariable("loadProcess", VariableBuilder.anURLVariable().value("../API/bpm/process")).build());
        Assertions.assertThat((Map)webResourceMap).hasSize(2);
    }

    @Test
    void should_collect_component_from_a_modal_container() throws Exception {
        Map webResourceMap = this.webResourcesVisitor.visit(ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{this.buttonGet}).with(Arrays.asList(this.buttonGet, this.btnSubmitTask))).build());
        Assertions.assertThat((Map)webResourceMap).hasSize(2);
    }

    @Test
    void should_collect_component_from_a_fragment() throws Exception {
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("fragment-id"))).thenReturn((Object)FragmentBuilder.aFragment().with(new Element[]{this.buttonGet}).withVariable("loadProcess", VariableBuilder.anURLVariable().value("../API/bpm/process")).build());
        Map webResourceMap = this.webResourcesVisitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").build());
        ((MapAssert)Assertions.assertThat((Map)webResourceMap).containsEntry((Object)"GET|bpm/process", (Object)new WebResource("GET", "bpm/process", "Variable"))).hasSize(2);
    }

    private Page setUpPageForResourcesTests(String id) {
        Page page = PageBuilder.aPage().withId(id).build();
        return page;
    }

    private Variable anApiVariable(String value) {
        return new Variable(DataType.URL, value);
    }

    @Test
    void should_add_bonita_api_extensions_resources_found_in_page_fileUpload_widget() throws Exception {
        Component fileUploadComponent = (Component)ComponentBuilder.aComponent().withWidgetId("pbUpload").withPropertyValue("url", ParameterType.CONSTANT.getValue(), (Object)"../API/extension/upload").build();
        Map properties = this.webResourcesVisitor.visit(fileUploadComponent);
        Assertions.assertThat((Map)properties).containsKey((Object)"POST|extension/upload");
    }

    @Test
    void should_add_bonita_resources_found_in_pages_widgets() throws Exception {
        Page page = this.setUpPageForResourcesTests("myPage");
        page.setVariables(Collections.singletonMap("foo", this.anApiVariable("../API/bpm/userTask?filter=mine")));
        Map properties = this.webResourcesVisitor.visit((Previewable)page);
        Assertions.assertThat((Map)properties).containsKey((Object)"GET|bpm/userTask");
    }

    @Test
    void should_add_bonita_resources_found_when_a_BusinessData_variable_is_declared() throws Exception {
        Page page = this.setUpPageForResourcesTests("myPage");
        page.setVariables(Collections.singletonMap("foo", new Variable(DataType.BUSINESSDATA, "{\"id\":\"com.company.model.DossierPret\"}")));
        Map properties = this.webResourcesVisitor.visit((Previewable)page);
        Assertions.assertThat((Map)properties).containsOnlyKeys((Object[])new String[]{"GET|bdm/businessData", "GET|bdm/businessDataQuery"});
    }

    @Test
    void should_add_bonita_api_extensions_resources_found_in_pages_widgets() throws Exception {
        Page page = this.setUpPageForResourcesTests("myPage");
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        variables.put("foo", this.anApiVariable("../API/extension/CA31/SQLToObject?filter=mine"));
        variables.put("bar", this.anApiVariable("../API/extension/user/4"));
        variables.put("aa", this.anApiVariable("../API/extension/group/list"));
        variables.put("session", this.anApiVariable("../API/extension/user/group/unusedid"));
        variables.put("ab", this.anApiVariable("http://localhost:8080/bonita/portal/API/extension/vehicule/voiture/roue?p=0&c=10&f=case_id={{caseId}}"));
        variables.put("user", this.anApiVariable("../API/identity/user/{{aaa}}/context"));
        variables.put("task", this.anApiVariable("../API/bpm/task/1/context"));
        variables.put("case", this.anApiVariable("../API/bpm/case{{dynamicQueries(true,0)}}"));
        variables.put("custom", this.anApiVariable("../API/extension/case{{dynamicQueries}}"));
        page.setVariables(variables);
        Map properties = this.webResourcesVisitor.visit((Previewable)page);
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)properties).containsKey((Object)"GET|bpm/task")).containsKey((Object)"GET|identity/user")).containsKey((Object)"GET|extension/group/list")).containsKey((Object)"GET|extension/vehicule/voiture/roue")).containsKey((Object)"GET|extension/user/4")).containsKey((Object)"GET|extension/user/group/unusedid")).containsKey((Object)"GET|extension/CA31/SQLToObject")).containsKey((Object)"GET|extension/case");
    }

    @Test
    void should_add_bonita_api_extensions_resources_found_in_page_data_table_properties() throws Exception {
        Component dataTableComponent = (Component)ComponentBuilder.aComponent().withWidgetId("dataTable").withPropertyValue("apiUrl", "constant", (Object)"../API/extension/car").build();
        Map properties = this.webResourcesVisitor.visit(dataTableComponent);
        Assertions.assertThat((Map)properties).containsKey((Object)"GET|extension/car");
    }

    @Test
    void should_add_bonita_api_extensions_resources_found_in_page_button_with_DELETE_action() throws Exception {
        Component dataTableComponent = (Component)ComponentBuilder.aComponent().withWidgetId("dataTable").withPropertyValue("action", "constant", (Object)"DELETE").withPropertyValue("url", ParameterType.INTERPOLATION.getValue(), (Object)"../API/bpm/document/1").build();
        Map properties = this.webResourcesVisitor.visit(dataTableComponent);
        Assertions.assertThat((Map)properties).containsKey((Object)"DELETE|bpm/document");
    }

    @Test
    void should_add_bonita_api_extensions_resources_found_in_page_button_with_POST_action() throws Exception {
        Component dataTableComponent = (Component)ComponentBuilder.aComponent().withWidgetId("dataTable").withPropertyValue("action", "constant", (Object)"POST").withPropertyValue("url", ParameterType.INTERPOLATION.getValue(), (Object)"../API/extension/user").build();
        Map properties = this.webResourcesVisitor.visit(dataTableComponent);
        Assertions.assertThat((Map)properties).containsKey((Object)"POST|extension/user");
    }

    @Test
    void should_add_start_process_resource_if_a_start_process_submit_is_contained_in_the_page() throws Exception {
        Component component = (Component)ComponentBuilder.aComponent().withWidgetId("button").withPropertyValue("action", "constant", (Object)"Start process").build();
        Map properties = this.webResourcesVisitor.visit(component);
        Assertions.assertThat((Map)properties).containsKey((Object)"POST|bpm/process");
    }

    @Test
    void should_add_submit_task_resource_if_a_start_submit_task_is_contained_in_the_page() throws Exception {
        Component component = (Component)ComponentBuilder.aComponent().withWidgetId("button").withPropertyValue("action", "constant", (Object)"Submit task").build();
        Map properties = this.webResourcesVisitor.visit(component);
        Assertions.assertThat((Map)properties).containsKey((Object)"POST|bpm/userTask");
    }

    @Test
    void should_combined_start_process_submit_task_and_bonita_resources() throws Exception {
        Page page = PageBuilder.aPage().with(new Element[]{ContainerBuilder.aContainer().with(Arrays.asList(ComponentBuilder.aComponent().withWidgetId("button").withPropertyValue("action", "constant", (Object)"Start process").build(), ComponentBuilder.aComponent().withWidgetId("button").withPropertyValue("action", "constant", (Object)"Submit task").build())).build()}).build();
        page.setVariables(Collections.singletonMap("foo", this.anApiVariable("/bonita/API/bpm/userTask")));
        Map properties = this.webResourcesVisitor.visit((Previewable)page);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)properties).containsKey((Object)"POST|bpm/userTask")).containsKey((Object)"GET|bpm/userTask")).containsKey((Object)"POST|bpm/process");
    }

    private Page setUpPageWithFragmentForResourcesTests() {
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragment").build();
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        variables.put("fragAPI", this.anApiVariable("../API/bpm/process/1"));
        variables.put("fragAPIExt", this.anApiVariable("../API/extension/user/4"));
        fragment.setVariables(variables);
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("myFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Page page = PageBuilder.aPage().withId("myPage").with(new Element[]{fragmentElement}).build();
        page.setVariables(Collections.singletonMap("foo", this.anApiVariable("../API/bpm/userTask?filter=mine")));
        TreeSet<String> fragmentIds = new TreeSet<String>();
        fragmentIds.add("myFragment");
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("myFragment"))).thenReturn((Object)fragment);
        return page;
    }

    @Test
    void should_add_bonita_resources_found_in_fragments() throws Exception {
        Page page = this.setUpPageWithFragmentForResourcesTests();
        Map properties = this.webResourcesVisitor.visit((Previewable)page);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)properties).containsKey((Object)"GET|bpm/userTask")).containsKey((Object)"GET|bpm/process")).containsKey((Object)"GET|extension/user/4");
    }

    @Test
    void should_add_bonita_resources_found_in_a_custom_widget() throws Exception {
        Widget widget = WidgetBuilder.aWidget().withId("timeLineWidget").custom().withWebResources(new WebResource[]{new WebResource("POST", "customInfo/definition", "timeLineWidget")}).build();
        Mockito.when((Object)((Widget)this.widgetRepository.get("timeLineWidget"))).thenReturn((Object)widget);
        Page page = PageBuilder.aPage().with(new Element[]{ContainerBuilder.aContainer().with(Arrays.asList(ComponentBuilder.aComponent().withWidgetId("timeLineWidget").build())).build()}).build();
        Map properties = this.webResourcesVisitor.visit((Previewable)page);
        Assertions.assertThat((Map)properties).containsKey((Object)"POST|customInfo/definition");
    }
}

