/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.ArtifactBuilderFactory;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.config.WorkspaceProperties;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class WorkspaceTest {
    private static final String CURRENT_MODEL_VERSION = "2.0";
    @TempDir
    public Path temporaryFolder;
    @TempDir
    public Path uiWorkspaceTmp;
    private Workspace workspace;
    private UiDesignerProperties uiDesignerProperties;
    private WorkspaceProperties workspaceProperties;

    WorkspaceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.uiDesignerProperties = new UiDesignerProperties();
        this.uiDesignerProperties.setModelVersion(CURRENT_MODEL_VERSION);
        this.workspaceProperties = this.uiDesignerProperties.getWorkspace();
        this.workspaceProperties.setPath(this.uiWorkspaceTmp);
        this.workspaceProperties.getPages().setDir(Files.createDirectory(this.temporaryFolder.resolve("pages"), new FileAttribute[0]));
        this.workspaceProperties.getWidgets().setDir(Files.createDirectory(this.temporaryFolder.resolve("widgets"), new FileAttribute[0]));
        this.workspaceProperties.getFragments().setDir(Files.createDirectory(this.temporaryFolder.resolve("fragments"), new FileAttribute[0]));
        ArtifactBuilder artifactBuilder = new ArtifactBuilderFactory(this.uiDesignerProperties).create();
        this.workspace = (Workspace)Mockito.spy((Object)artifactBuilder.getWorkspace());
        this.workspace.initialized.set(false);
    }

    private void createWidget(String id, String content) throws IOException {
        Path widgetPath = this.temporaryFolder.resolve("widgets/" + id);
        if (Files.exists(widgetPath, new LinkOption[0])) {
            try (Stream<Path> files = Files.walk(widgetPath, new FileVisitOption[0]);){
                files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        Path widgetFolder = Files.createDirectories(this.temporaryFolder.resolve("widgets").resolve(id), new FileAttribute[0]);
        Path widgetJson = Files.createFile(widgetFolder.resolve(id + ".json"), new FileAttribute[0]);
        byte[] fileContent = content.getBytes(StandardCharsets.UTF_8);
        Files.write(widgetJson, fileContent, StandardOpenOption.CREATE);
    }

    private String contentOf(Path path) throws IOException {
        return new String(Files.readAllBytes(path));
    }

    @Test
    void should_ensure_that_folders_page_and_widgets_are_created() throws Exception {
        this.workspace.initialize();
        this.getClass().getResourceAsStream("");
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("widgets")).exists();
    }

    @Test
    void should_not_throw_exception_when_a_folder_exist_before_init() throws Exception {
        Path widgetFolder;
        if (!Files.exists(this.temporaryFolder.resolve("pages"), new LinkOption[0])) {
            Files.createDirectory(this.temporaryFolder.resolve("pages"), new FileAttribute[0]);
        }
        if (!Files.exists(widgetFolder = this.temporaryFolder.resolve("widgets"), new LinkOption[0])) {
            Files.createDirectory(this.temporaryFolder.resolve("widgets"), new FileAttribute[0]);
        }
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("widgets")).exists();
    }

    @Test
    void should_copy_widget_to_widget_repository_folder() throws Exception {
        this.workspace.initialize();
        Path widgetsPath = this.workspaceProperties.getWidgets().getDir();
        Assertions.assertThat((Path)widgetsPath.resolve("pbButton/pbButton.json")).exists();
        Assertions.assertThat((Path)widgetsPath.resolve("pbButton/help.html")).exists();
        Assertions.assertThat((Path)widgetsPath.resolve("pbMissingHelp/pbMissingHelp.json")).exists();
    }

    @Test
    void should_not_copy_widget_file_if_it_is_already_in_widget_repository_with_same_version() throws Exception {
        String existingWidgetContent = "{\"id\":\"pbLabel\", \"template\": \"<div>Hello</div>\", \"designerVersion\": \"2.0\"}";
        this.createWidget("pbLabel", existingWidgetContent);
        this.workspace.initialize();
        Assertions.assertThat((String)this.contentOf(this.workspaceProperties.getWidgets().getDir().resolve("pbLabel/pbLabel.json"))).isEqualTo(existingWidgetContent);
    }

    @Test
    void should_copy_widget_file_if_it_is_already_in_widget_repository_folder_with_a_former_version() throws Exception {
        String existingWidgetContent = this.getClass().getResourceAsStream("/workspace/widgets/pbWidgetToOverride/pbWidgetToOverride.json").readAllBytes().toString();
        this.workspace.initialize();
        Assertions.assertThat((String)this.contentOf(this.workspaceProperties.getWidgets().getDir().resolve("pbWidgetToOverride/pbWidgetToOverride.json"))).isNotEqualTo((Object)existingWidgetContent);
    }

    @Test
    void should_delete_page_reference_when_page_doesnt_exist_anymore_but_any_file_stay_on_filesystem() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("pages").resolve("myPageToRemove").resolve("js"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("pages").resolve(".gitignore"), new FileAttribute[0]);
        this.workspace.cleanPageWorkspace();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve("myPageToRemove")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve(".gitignore")).exists();
    }

    @Test
    void should_delete_only_js_folder_for_page_artifact_when_page_exist() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("pages").resolve("myPage").resolve("js"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("pages").resolve("myPage/myPage.json"), new FileAttribute[0]);
        this.workspace.cleanPageWorkspace();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve("myPage")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve("myPage").resolve("js")).doesNotExist();
    }

    @Test
    void should_keep_file_with_a_reference_on_workspace_when_cleanup_is_called() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("pages").resolve(".metadata"), new FileAttribute[0]);
        Files.createDirectories(this.temporaryFolder.resolve("pages").resolve("myPage"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("pages/myPage/myPage.json"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("pages/.metadata/.index.json"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("pages/.metadata/myPage.json"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("pages/.metadata/oldestPage.json"), new FileAttribute[0]);
        this.workspace.cleanPageWorkspace();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve("myPage")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve("myPage").resolve("js")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve(".metadata").resolve(".index.json")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve(".metadata").resolve("oldestPage.json")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve(".metadata").resolve("myPage.json")).exists();
    }

    @Test
    void should_ensure_that_folders_page_widgets_fragments_are_created() throws Exception {
        this.workspace.initialize();
        Assertions.assertThat((Path)this.workspaceProperties.getPages().getDir()).exists();
        Assertions.assertThat((Path)this.workspaceProperties.getWidgets().getDir()).exists();
        Assertions.assertThat((Path)this.workspaceProperties.getFragments().getDir()).exists();
    }

    @Test
    void should_not_throw_exception_when_a_folder_exist_before_init_with_fragment() throws Exception {
        if (!Files.exists(this.temporaryFolder.resolve("fragments"), new LinkOption[0])) {
            Files.createDirectories(this.temporaryFolder.resolve("fragments"), new FileAttribute[0]);
        }
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("fragments")).exists();
    }

    @Test
    void should_not_copy_widget_file_if_it_is_already_in_widget_repository_folder() throws Exception {
        String existingWidget = "{\"id\":\"pbLabel\", \"template\": \"<div>Hello</div>\", \"designerVersion\": \"2.0\"}";
        byte[] fileContent = existingWidget.getBytes(StandardCharsets.UTF_8);
        this.createWidget("pbLabel", existingWidget);
        this.workspace.initialize();
        Path labelFile = this.workspaceProperties.getWidgets().getDir().resolve("pbLabel/pbLabel.json");
        Assertions.assertThat((Path)labelFile).exists().hasBinaryContent(fileContent);
    }

    @Test
    void should_delete_fragment_reference_when_fragment_doesnt_exist_anymore_but_any_file_stay_on_filesystem() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("fragments/myFragment"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("fragments/myFragment/widgets-abcd487.min.js"), new FileAttribute[0]);
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("fragments").resolve("myFragment")).doesNotExist();
    }

    @Test
    void should_delete_only_js_file_for_fragment_artifact_when_fragment_descriptor_exist() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("fragments/myFragment"), new FileAttribute[0]);
        Files.createDirectories(this.temporaryFolder.resolve("fragments/.metadata"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("fragments/myFragment/widgets-abcd487.min.js"), new FileAttribute[0]);
        Files.write(Files.createFile(this.temporaryFolder.resolve("fragments/myFragment/myFragment.json"), new FileAttribute[0]), "{}".getBytes(), StandardOpenOption.WRITE);
        Files.write(Files.createFile(this.temporaryFolder.resolve("fragments/.metadata/myFragment.json"), new FileAttribute[0]), "{}".getBytes(), StandardOpenOption.WRITE);
        Files.write(Files.createFile(this.temporaryFolder.resolve("fragments/.metadata/oldestFragment.json"), new FileAttribute[0]), "{}".getBytes(), StandardOpenOption.WRITE);
        Files.createFile(this.temporaryFolder.resolve("fragments/.DSSTORE"), new FileAttribute[0]);
        Files.createFile(this.temporaryFolder.resolve("fragments/.gitignore"), new FileAttribute[0]);
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("fragments").resolve("myFragment").resolve("widgets-abcd487.min.js")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("fragments").resolve("myFragment")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("fragments").resolve(".DSSTORE")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("fragments").resolve(".gitignore")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("fragments").resolve(".metadata").resolve("oldestFragment.json")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("fragments").resolve(".metadata").resolve("myFragment.json")).exists();
    }

    @Test
    void should_initialize_workspace() throws Exception {
        this.workspace.initialize();
        ((Workspace)Mockito.verify((Object)this.workspace)).doInitialize();
        ((Workspace)Mockito.verify((Object)this.workspace)).cleanPageWorkspace();
    }

    @Test
    void should_refresh_index_file_in_metadata_folder_when_initialize_is_called() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("pages/myPage"), new FileAttribute[0]);
        Files.createDirectories(this.temporaryFolder.resolve("pages/.metadata"), new FileAttribute[0]);
        String pageContent = "{\"designerVersion\": \"1.0.0\",\"id\": \"myPage\",\"uuid\": \"123ca6c5-9a72-4a03-a890-2e6bc2aeed93\",\"name\": \"myPage\",\"type\": \"page\",\"lastUpdate\": 1436966572684,\"rows\": [[]],\"assets\": [],\"data\": {}}";
        Files.write(Files.createFile(this.temporaryFolder.resolve("pages/myPage/myPage.json"), new FileAttribute[0]), pageContent.getBytes(), StandardOpenOption.WRITE);
        Files.write(Files.createFile(this.temporaryFolder.resolve("pages/.metadata/.index.json"), new FileAttribute[0]), "{\"4a732c6f-254b-4b37-841f-9582696d40e9\":\"anyPage\",\"225ca6c5-9a72-4a03-a890-2e6bc2aeed93\":\"myPage\"}".getBytes(), StandardOpenOption.WRITE);
        Files.createFile(this.temporaryFolder.resolve("pages/.metadata/oldestPage.json"), new FileAttribute[0]);
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve("myPage")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve("myPage").resolve("js")).doesNotExist();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve(".metadata").resolve(".index.json")).exists());
        Assertions.assertThat((String)this.contentOf(this.temporaryFolder.resolve("pages").resolve(".metadata").resolve(".index.json"))).isEqualTo("{\"123ca6c5-9a72-4a03-a890-2e6bc2aeed93\":\"myPage\"}");
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve(".metadata").resolve("oldestPage.json")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.resolve("pages").resolve(".metadata").resolve("myPage.json")).exists();
    }
}

