/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.bonitasoft.web.angularjs.AngularJsGeneratorStrategy;
import org.bonitasoft.web.angularjs.GeneratorProperties;
import org.bonitasoft.web.angularjs.export.WidgetsExportStep;
import org.bonitasoft.web.angularjs.rendering.DirectiveFileGenerator;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.DefaultArtifactBuilder;
import org.bonitasoft.web.designer.UiDesignerCore;
import org.bonitasoft.web.designer.UiDesignerCoreFactory;
import org.bonitasoft.web.designer.common.GeneratorStrategy;
import org.bonitasoft.web.designer.common.IGeneratorProperties;
import org.bonitasoft.web.designer.common.export.ExportStep;
import org.bonitasoft.web.designer.common.visitor.FragmentIdVisitor;
import org.bonitasoft.web.designer.common.visitor.WidgetIdVisitor;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.export.FragmentExporter;
import org.bonitasoft.web.designer.controller.export.PageExporter;
import org.bonitasoft.web.designer.controller.export.WidgetExporter;
import org.bonitasoft.web.designer.controller.export.properties.FragmentPropertiesBuilder;
import org.bonitasoft.web.designer.controller.export.properties.PagePropertiesBuilder;
import org.bonitasoft.web.designer.controller.export.properties.WidgetPropertiesBuilder;
import org.bonitasoft.web.designer.controller.export.steps.AssetExportStep;
import org.bonitasoft.web.designer.controller.export.steps.FragmentPropertiesExportStep;
import org.bonitasoft.web.designer.controller.export.steps.FragmentsExportStep;
import org.bonitasoft.web.designer.controller.export.steps.PagePropertiesExportStep;
import org.bonitasoft.web.designer.controller.export.steps.WidgetByIdExportStep;
import org.bonitasoft.web.designer.controller.importer.FragmentImporter;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.controller.importer.PageImporter;
import org.bonitasoft.web.designer.controller.importer.WidgetImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetDependencyImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.DependencyImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.FragmentDependencyImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.WidgetDependencyImporter;
import org.bonitasoft.web.designer.i18n.I18nInitializer;
import org.bonitasoft.web.designer.i18n.LanguagePackBuilder;
import org.bonitasoft.web.designer.i18n.LanguagePackFactory;
import org.bonitasoft.web.designer.migration.LiveRepositoryUpdate;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.workspace.ResourcesCopier;
import org.bonitasoft.web.designer.workspace.Workspace;

public class ArtifactBuilderFactory {
    private final UiDesignerProperties uiDesignerProperties;
    private final GeneratorProperties generatorProperties;
    private final JsonHandler jsonHandler;
    private final UiDesignerCore core;

    public ArtifactBuilderFactory(UiDesignerProperties uiDesignerProperties) {
        this.uiDesignerProperties = uiDesignerProperties;
        this.jsonHandler = new JsonHandlerFactory().create();
        this.generatorProperties = new GeneratorProperties(uiDesignerProperties.getWorkspaceUid().getPath());
        this.generatorProperties.setLiveBuildEnabled(uiDesignerProperties.getWorkspaceUid().isLiveBuildEnabled());
        this.core = new UiDesignerCoreFactory(this.uiDesignerProperties, this.generatorProperties, this.jsonHandler).create();
    }

    public ArtifactBuilder create() {
        FragmentIdVisitor fragmentIdVisitor = new FragmentIdVisitor(this.core.getFragmentRepository());
        WidgetIdVisitor widgetIdVisitor = new WidgetIdVisitor(this.core.getFragmentRepository());
        DirectiveFileGenerator directiveFileGenerator = new DirectiveFileGenerator(this.uiDesignerProperties.getWorkspace().getWidgets().getDir(), this.core.getWidgetRepository(), widgetIdVisitor);
        AngularJsGeneratorStrategy generatorStrategy = new AngularJsGeneratorStrategy(this.jsonHandler, this.core.getWatcher(), fragmentIdVisitor, directiveFileGenerator, widgetIdVisitor, this.core.getPageRepository(), this.core.getWidgetRepository(), this.core.getWidgetAssetRepository(), this.core.getPageAssetRepository(), this.core.getFragmentRepository(), this.uiDesignerProperties.getWorkspace().getWidgets().getDir(), this.generatorProperties);
        ExportStep[] commonExportStep = new ExportStep[]{new PagePropertiesExportStep(new PagePropertiesBuilder(this.uiDesignerProperties, this.core.getPageService())), new AssetExportStep(this.core.getPageAssetRepository()), new FragmentsExportStep(fragmentIdVisitor, this.uiDesignerProperties.getWorkspace().getFragments().getDir())};
        ExportStep[] pageExportSteps = (ExportStep[])Stream.concat(Arrays.stream(commonExportStep), Arrays.stream(generatorStrategy.getPageExportStep())).toArray(ExportStep[]::new);
        ExportStep[] fragmentExportSteps = new ExportStep[]{new WidgetsExportStep(this.uiDesignerProperties.getWorkspace().getWidgets().getDir(), widgetIdVisitor, directiveFileGenerator), new FragmentsExportStep(fragmentIdVisitor, this.uiDesignerProperties.getWorkspace().getFragments().getDir()), new FragmentPropertiesExportStep(new FragmentPropertiesBuilder(this.uiDesignerProperties))};
        ExportStep[] widgetExportSteps = new ExportStep[]{new WidgetByIdExportStep(this.core.getWidgetRepository(), new WidgetPropertiesBuilder(this.uiDesignerProperties))};
        WidgetExporter widgetExporter = new WidgetExporter(this.jsonHandler, this.core.getWidgetService(), widgetExportSteps);
        FragmentExporter fragmentExporter = new FragmentExporter(this.jsonHandler, this.core.getFragmentService(), fragmentExportSteps);
        PageExporter pageExporter = new PageExporter(this.jsonHandler, this.core.getPageService(), pageExportSteps);
        AssetDependencyImporter<Widget> widgetAssetDependencyImporter = new AssetDependencyImporter<Widget>(this.core.getWidgetAssetRepository());
        FragmentDependencyImporter fragmentDependencyImporter = new FragmentDependencyImporter(this.core.getFragmentRepository());
        WidgetDependencyImporter widgetDependencyImporter = new WidgetDependencyImporter(this.core.getWidgetRepository(), widgetAssetDependencyImporter);
        DependencyImporter[] widgetDependencyImporters = new DependencyImporter[]{widgetAssetDependencyImporter};
        WidgetImporter widgetImporter = new WidgetImporter(this.jsonHandler, this.core.getWidgetService(), this.core.getWidgetRepository(), widgetDependencyImporters);
        DependencyImporter[] fragmentDependencyImporters = new DependencyImporter[]{fragmentDependencyImporter, widgetDependencyImporter};
        FragmentImporter fragmentImporter = new FragmentImporter(this.jsonHandler, this.core.getFragmentService(), this.core.getFragmentRepository(), fragmentDependencyImporters);
        DependencyImporter[] pageDependencyImporters = new DependencyImporter[]{fragmentDependencyImporter, widgetDependencyImporter, new AssetDependencyImporter<Page>(this.core.getPageAssetRepository())};
        PageImporter pageImporter = new PageImporter(this.jsonHandler, this.core.getPageService(), this.core.getPageRepository(), pageDependencyImporters);
        ResourcesCopier resourcesCopier = new ResourcesCopier();
        Workspace workspace = new Workspace(this.uiDesignerProperties, this.core.getWidgetRepository(), this.core.getPageRepository(), (GeneratorStrategy)generatorStrategy, this.core.getWidgetAssetDependencyImporter(), resourcesCopier, List.of(new LiveRepositoryUpdate(this.core.getPageRepository(), this.core.getPageMigrationStepsList()), new LiveRepositoryUpdate(this.core.getFragmentRepository(), this.core.getFragmentMigrationStepsList()), new LiveRepositoryUpdate(this.core.getWidgetRepository(), this.core.getWidgetMigrationStepsList())), this.jsonHandler);
        workspace.initialize();
        I18nInitializer i18nInitializer = new I18nInitializer(new LanguagePackBuilder(this.core.getWatcher(), new LanguagePackFactory(this.jsonHandler), generatorStrategy.getGeneratorProperties()), resourcesCopier, (IGeneratorProperties)generatorStrategy.getGeneratorProperties());
        i18nInitializer.initialize();
        return new DefaultArtifactBuilder(workspace, this.core.getWidgetService(), this.core.getFragmentService(), this.core.getPageService(), pageExporter, fragmentExporter, widgetExporter, generatorStrategy.getHtmlGenerator(), new ImportStore(), pageImporter, fragmentImporter, widgetImporter);
    }

    public ArtifactBuilderFactory(UiDesignerProperties uiDesignerProperties, GeneratorProperties generatorProperties, JsonHandler jsonHandler, UiDesignerCore core) {
        this.uiDesignerProperties = uiDesignerProperties;
        this.generatorProperties = generatorProperties;
        this.jsonHandler = jsonHandler;
        this.core = core;
    }
}

