/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.common.export.ExportStep;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.controller.export.ExportException;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.ModelException;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.ArtifactService;

public abstract class Exporter<T extends DesignerArtifact> {
    protected final ExportStep<T>[] exportSteps;
    protected final ArtifactService<T> artifactService;
    protected JsonHandler jsonHandler;

    @SafeVarargs
    protected Exporter(JsonHandler jsonHandler, ArtifactService<T> artifactService, ExportStep<T> ... exportSteps) {
        this.jsonHandler = jsonHandler;
        this.artifactService = artifactService;
        this.exportSteps = exportSteps;
    }

    protected abstract String getComponentType();

    public void handleFileExport(String id, OutputStream stream) throws ModelException, ExportException, IOException {
        ByteArrayOutputStream zipStream;
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Id is needed to successfully export a component");
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             Zipper zipper = new Zipper((OutputStream)outputStream);){
            zipStream = outputStream;
            DesignerArtifact identifiable = (DesignerArtifact)this.artifactService.get(id);
            if (identifiable.getStatus() == null) {
                identifiable.setStatus(this.artifactService.getStatus(identifiable));
            }
            if (!identifiable.getStatus().isCompatible()) {
                throw new ModelException(String.format("%s build failed. A newer UI Designer version is required.", identifiable.getName()));
            }
            if (identifiable instanceof Widget) {
                ((Widget)identifiable).prepareWidgetToSerialize();
            }
            byte[] json = this.jsonHandler.toJson((Object)identifiable, JsonViewPersistence.class);
            zipper.addToZip(json, String.format("%s/%s.json", "resources", this.getComponentType()));
            for (ExportStep<T> exporter : this.exportSteps) {
                exporter.execute(zipper, (Identifiable)identifiable);
            }
        }
        catch (ModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExportException(String.format("Technical error on zip creation %s with id %s", this.getComponentType(), id), e);
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(zipStream.toByteArray());){
            IOUtils.copy((InputStream)inputStream, (OutputStream)stream);
        }
        catch (Exception e) {
            throw new ExportException(String.format("Technical error when exporting %s with id %s", this.getComponentType(), id), e);
        }
    }
}

