/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.bonitasoft.web.designer.common.generator.rendering.GenerationException;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.model.fragment.Fragment;

public class FragmentPropertiesBuilder {
    private final UiDesignerProperties uiDesignerProperties;

    public FragmentPropertiesBuilder(UiDesignerProperties uiDesignerProperties) {
        this.uiDesignerProperties = uiDesignerProperties;
    }

    public byte[] build(Fragment fragment) throws GenerationException, IOException {
        Properties properties = new Properties();
        properties.put("name", fragment.getName());
        properties.put("contentType", String.valueOf(fragment.getType()).toLowerCase(Locale.ENGLISH));
        properties.put("designerVersion", this.uiDesignerProperties.getVersion());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "Generated by Bonita UI Designer");
        return byteArrayOutputStream.toByteArray();
    }
}

