/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleAddErrorDialogPropertiesMigrationStep
extends AbstractMigrationStep<Page> {
    private static final Logger log = LoggerFactory.getLogger(StyleAddErrorDialogPropertiesMigrationStep.class);
    private final AssetService<Page> assetService;

    public StyleAddErrorDialogPropertiesMigrationStep(AssetService<Page> assetService) {
        this.assetService = assetService;
    }

    @Override
    public Optional<MigrationStepReport> migrate(Page artifact) throws IOException {
        for (Asset asset : artifact.getAssets()) {
            if (!asset.getName().equals("style.css")) continue;
            String pageStyleCssContent = this.assetService.getAssetContent(artifact, asset);
            this.assetService.save(artifact, asset, this.getMigratedAssetContent(pageStyleCssContent));
            log.info("[MIGRATION] Adding error dialog classes in asset [{}] to {} [{}] (introduced in 1.17.5)", new Object[]{asset.getName(), artifact.getType(), artifact.getName()});
        }
        return Optional.empty();
    }

    @Override
    public String getErrorMessage() {
        return "Error during adding error dialog classes in asset, Missing templates/page/assets/css/style.css from classpath";
    }

    private byte[] getMigratedAssetContent(String styleCssContent) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/templates/migration/assets/css/styleAddErrorDialogProperties.css");){
            byte[] byArray;
            try (SequenceInputStream sis = new SequenceInputStream(new ByteArrayInputStream(styleCssContent.getBytes(StandardCharsets.UTF_8)), new ByteArrayInputStream(IOUtils.toByteArray((InputStream)is)));){
                byArray = IOUtils.toByteArray((InputStream)sis);
            }
            return byArray;
        }
    }
}

